/*
 * Decompiled with CFR 0.152.
 */
package kotowari.middleware.serdes;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;

public class ToStringBodyWriter
implements MessageBodyWriter<Object> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Objects.equals(mediaType.getType(), "text") || mediaType.isWildcardType();
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        StringBodyConverter converter = StringBodyConverter.valueOfOrDefault(mediaType.getSubtype());
        entityStream.write(converter.convert(o).getBytes("UTF-8"));
    }

    private static String escapeHtml(String s) {
        return s.replaceAll("\"", "&quot;").replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    private static String escapeXml(String s) {
        return ToStringBodyWriter.escapeHtml(s).replace("'", "&apos;").replaceAll("[\u0000-\u001f\ufffe\uffff]+", "");
    }

    private static enum StringBodyConverter {
        PLAIN("%s", s -> s),
        XML("<message>%s</message>", x$0 -> ToStringBodyWriter.access$100(x$0)),
        HTML("<html><body>%s</body></html>", x$0 -> ToStringBodyWriter.access$000(x$0));

        private String format;
        private Function<String, String> escaper;

        private StringBodyConverter(String format, Function<String, String> escaper) {
            this.format = format;
            this.escaper = escaper;
        }

        public String convert(Object o) {
            return String.format(Locale.US, this.format, this.escaper.apply(Objects.toString(o, "")));
        }

        public static StringBodyConverter valueOfOrDefault(String name) {
            return Arrays.stream(StringBodyConverter.values()).filter(c -> c.name().equalsIgnoreCase(name)).findFirst().orElse(PLAIN);
        }
    }
}

