/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpUtils {
    private static final Pattern[] UNOPTIONALIZED_PTNS = new Pattern[]{Pattern.compile("\\A\\(\\?:(.*)\\)\\?\\Z"), Pattern.compile("\\A(.|\\(.*\\))\\?\\Z")};

    public static String escape(String pattern) {
        return pattern.replaceAll("([\\.\\-\\[\\]])", "\\\\$1");
    }

    public static String optionalize(String pattern) {
        String unoptionalizedPattern = RegexpUtils.unoptionalize(pattern);
        if (Pattern.matches("\\A(.|\\(.*\\))\\Z", unoptionalizedPattern)) {
            return pattern + "?";
        }
        return "(?:" + pattern + ")?";
    }

    public static String unoptionalize(String pattern) {
        for (Pattern regexp : UNOPTIONALIZED_PTNS) {
            Matcher m = regexp.matcher(pattern);
            if (!m.find()) continue;
            return m.group(1);
        }
        return pattern;
    }
}

