/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing;

import enkan.collection.OptionMap;
import enkan.util.CodecUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotowari.routing.Segment;
import kotowari.routing.segment.DividerSegment;

public class Route {
    private List<Segment> segments;
    private OptionMap constraints;
    private OptionMap conditions;
    private List<String> significantKeys;
    private OptionMap parameterShell;
    private boolean matchingPrepared;
    private Class<?> controllerRequirement;
    private String actionRequirement;
    private Pattern recognizePattern;

    public Route(List<Segment> segments, OptionMap constraints, OptionMap conditions) {
        this.segments = segments;
        this.constraints = constraints;
        this.conditions = conditions;
        if (!this.significantKeys().contains("action") && !constraints.containsKey((Object)"action")) {
            constraints.put((Object)"action", (Object)"index");
            this.significantKeys().add("action");
        }
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public String buildQueryString(Map<String, String> hash) {
        ArrayList<String> elements = new ArrayList<String>();
        for (String key : hash.keySet()) {
            String value = hash.get(key);
            if (value.isEmpty()) continue;
            elements.add(key + "=" + value);
        }
        return String.join((CharSequence)"&", elements);
    }

    public List<String> significantKeys() {
        if (this.significantKeys != null) {
            return this.significantKeys;
        }
        Set sk = this.segments.stream().filter(Segment::hasKey).map(Segment::getKey).collect(Collectors.toSet());
        sk.addAll(this.constraints.keySet());
        this.significantKeys = new ArrayList(sk);
        return this.significantKeys;
    }

    public String toString() {
        StringBuilder segs = new StringBuilder();
        for (Segment s : this.segments) {
            segs.append(s.toString());
        }
        List methods = this.conditions.getList("method");
        if (methods.isEmpty()) {
            methods.add("any");
        }
        StringBuilder out = new StringBuilder(256);
        for (Object method : methods) {
            out.append(String.format(Locale.US, "%-6s %-40s %s\n", method.toString().toUpperCase(), segs.toString(), this.constraints));
        }
        return out.toString();
    }

    public OptionMap recognize(String path, String method) {
        List methods = this.conditions.getList("method");
        if (!methods.isEmpty() && !methods.contains(method)) {
            return null;
        }
        if (this.recognizePattern == null) {
            this.recognizePattern = Pattern.compile(this.recognitionPattern(true));
        }
        Matcher match = this.recognizePattern.matcher(path);
        OptionMap params = null;
        if (match.find()) {
            int nextCapture = 1;
            params = OptionMap.of((Object[])new Object[0]);
            params.putAll((Map)this.getParameterShell());
            for (Segment segment : this.segments) {
                segment.matchExtraction(params, match, nextCapture);
                nextCapture += segment.numberOfCaptures();
            }
        }
        return params;
    }

    private String recognitionPattern(boolean wrap) {
        String pattern = "";
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            Segment segment = this.segments.get(i);
            pattern = segment.buildPattern(pattern);
        }
        return wrap ? "\\A" + pattern + "\\Z" : pattern;
    }

    private String getUrlEncodedString(OptionMap options, String key) {
        Object value = options.get((Object)key);
        if (value == null) {
            return "";
        }
        if (value instanceof Collection) {
            Collection values = (Collection)Collection.class.cast(value);
            ArrayList<String> pairs = new ArrayList<String>(values.size());
            for (Object val : values) {
                if (val == null) {
                    val = "";
                }
                pairs.add(CodecUtils.urlEncode((String)key) + "=" + CodecUtils.urlEncode((String)val.toString()));
            }
            return String.join((CharSequence)"&", pairs);
        }
        return CodecUtils.urlEncode((String)key) + "=" + CodecUtils.urlEncode((String)value.toString());
    }

    private String buildQueryString(OptionMap hash, List<String> onlyKeys) {
        ArrayList elements = new ArrayList(hash.size());
        if (onlyKeys == null) {
            onlyKeys = new ArrayList<String>(hash.keySet());
        }
        elements.addAll(onlyKeys.stream().filter(arg_0 -> hash.containsKey(arg_0)).map(key -> this.getUrlEncodedString(hash, (String)key)).collect(Collectors.toList()));
        return elements.isEmpty() ? "" : "?" + String.join((CharSequence)"&", elements);
    }

    private OptionMap getParameterShell() {
        if (this.parameterShell == null) {
            OptionMap options = OptionMap.of((Object[])new Object[0]);
            this.constraints.entrySet().stream().filter(e -> !(e.getValue() instanceof Pattern)).forEach(e -> options.put(e.getKey(), e.getValue()));
            this.parameterShell = options;
        }
        return this.parameterShell;
    }

    public boolean matchesController(Class<?> controller) {
        this.prepareMatching();
        return this.controllerRequirement != null && controller.equals(this.controllerRequirement);
    }

    public boolean matchesControllerAndAction(Class<?> controller, String action) {
        this.prepareMatching();
        return !(this.controllerRequirement != null && !controller.equals(this.controllerRequirement) || this.actionRequirement != null && !action.equals(this.actionRequirement));
    }

    public String generate(OptionMap options, OptionMap hash) {
        if (this.generationRequirements(options, hash)) {
            int lastIndex = this.segments.size() - 1;
            Segment last = this.segments.get(lastIndex);
            String path = last.stringStructure(this.segments.subList(0, lastIndex), hash);
            if (this.segments.size() > 1 && last instanceof DividerSegment && "/".equals(last.getValue())) {
                path = path + "/";
            }
            return this.appendQueryString(path, hash, this.extraKeys(options));
        }
        return null;
    }

    public boolean generationRequirements(OptionMap options, OptionMap hash) {
        boolean matched = true;
        for (String key : this.constraints.keySet()) {
            Object req = this.constraints.get((Object)key);
            if (req instanceof Pattern) {
                matched &= hash.containsKey((Object)key) && ((Pattern)req).matcher(options.getString(key)).matches();
                continue;
            }
            matched &= hash.getString(key).equals(this.constraints.getString(key));
        }
        return matched;
    }

    private String requirementFor(String key) {
        if (this.constraints.containsKey((Object)key)) {
            return this.constraints.getString(key);
        }
        for (Segment segment : this.segments) {
            if (!segment.hasKey() || !segment.getKey().equals(key)) continue;
            return segment.getRegexp();
        }
        return null;
    }

    private void prepareMatching() {
        if (!this.matchingPrepared) {
            this.controllerRequirement = (Class)this.constraints.get((Object)"controller");
            this.actionRequirement = this.requirementFor("action");
            this.matchingPrepared = true;
        }
    }

    private String appendQueryString(String path, OptionMap hash, List<String> queryKeys) {
        if (path == null) {
            return null;
        }
        if (queryKeys == null) {
            queryKeys = this.extraKeys(hash);
        }
        return path + this.buildQueryString(hash, queryKeys);
    }

    private List<String> extraKeys(OptionMap hash) {
        ArrayList<String> extraKeys = new ArrayList<String>();
        if (hash != null) {
            extraKeys.addAll(hash.keySet().stream().filter(key -> !this.significantKeys.contains(key)).collect(Collectors.toList()));
        }
        return extraKeys;
    }

    public String getActionRequirement() {
        return this.actionRequirement;
    }
}

