/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing;

import enkan.collection.OptionMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotowari.routing.RegexpUtils;
import kotowari.routing.Route;
import kotowari.routing.Segment;
import kotowari.routing.segment.DividerSegment;
import kotowari.routing.segment.DynamicSegment;
import kotowari.routing.segment.OptionalFormatSegment;
import kotowari.routing.segment.PathSegment;
import kotowari.routing.segment.StaticSegment;

public class RouteBuilder {
    public static final String[] SEPARATORS = new String[]{"/", ".", "?", "(", ")"};
    private static final Pattern PTN_OPTIONAL_FORMAT = Pattern.compile("\\A\\.(:format?)/");
    private static final Pattern PTN_SYMBOL = Pattern.compile("\\A(?::(\\w+)|\\(:(\\w+)\\))");
    private static final Pattern PTN_PATH = Pattern.compile("\\A\\*(\\w+)");
    private static final Pattern PTN_STATIC = Pattern.compile("\\A\\?(.*?)\\?");
    private static final List<String> HTTP_METHODS = Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "OPTIONS");
    private static final List<String> optionalSeparators = Collections.singletonList("/");
    private static final Pattern separatorRegexp = Pattern.compile("[" + RegexpUtils.escape(String.join((CharSequence)"", SEPARATORS)) + "]");
    private static final Pattern nonseparatorRegexp = Pattern.compile("\\A([^" + RegexpUtils.escape(String.join((CharSequence)"", SEPARATORS)) + "]+)");

    public List<Segment> segmentsForRoutePath(String path) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        StringBuilder rest = new StringBuilder(path);
        while (rest.length() > 0) {
            Segment segment = this.segmentFor(rest);
            segments.add(segment);
        }
        return segments;
    }

    public Segment segmentFor(StringBuilder sb) {
        String str = sb.toString();
        Segment segment = null;
        Matcher m = PTN_OPTIONAL_FORMAT.matcher(str);
        if (m.find()) {
            segment = new OptionalFormatSegment();
        } else {
            m = PTN_SYMBOL.matcher(str);
            if (m.find()) {
                OptionMap options = OptionMap.of((Object[])new Object[0]);
                String key = m.group(1);
                if (key.isEmpty()) {
                    key = m.group(2);
                    options.put((Object)"wrapParentheses", (Object)true);
                }
                segment = new DynamicSegment(key, options);
            } else {
                m = PTN_PATH.matcher(str);
                if (m.find()) {
                    segment = new PathSegment(m.group(1), OptionMap.of((Object[])new Object[]{"optional", true}));
                } else {
                    m = PTN_STATIC.matcher(str);
                    if (m.find()) {
                        segment = new StaticSegment(m.group(1), OptionMap.of((Object[])new Object[]{"optional", true}));
                    } else {
                        m = nonseparatorRegexp.matcher(str);
                        if (m.find()) {
                            segment = new StaticSegment(m.group(1));
                        } else {
                            m = separatorRegexp.matcher(str);
                            if (m.find()) {
                                segment = new DividerSegment(m.group(), OptionMap.of((Object[])new Object[]{"optional", optionalSeparators.contains(m.group())}));
                            }
                        }
                    }
                }
            }
        }
        sb.delete(0, m.end());
        return segment;
    }

    public OptionMap[] divideRouteOptions(List<Segment> segments, OptionMap options) {
        options.remove((Object)"pathPrefix");
        options.remove((Object)"namePrefix");
        if (options.containsKey((Object)"namespace")) {
            String namespace = options.getString("namespace").replace("/$", "");
            options.remove((Object)"namespace");
            options.put((Object)"controller", (Object)(namespace.replace('/', '.') + "." + options.get((Object)"controller")));
        }
        OptionMap requirements = Optional.ofNullable((OptionMap)options.remove((Object)"requirements")).orElse(OptionMap.of((Object[])new Object[0]));
        OptionMap defaults = Optional.ofNullable((OptionMap)options.remove((Object)"defaults")).orElse(OptionMap.of((Object[])new Object[0]));
        OptionMap conditions = Optional.ofNullable((OptionMap)options.remove((Object)"conditions")).orElse(OptionMap.of((Object[])new Object[0]));
        this.validateRouteConditions(conditions);
        List pathKeys = segments.stream().filter(Segment::hasKey).map(Segment::getKey).collect(Collectors.toList());
        for (Map.Entry e : options.entrySet()) {
            if (pathKeys.contains(e.getKey()) && !(e.getValue() instanceof Pattern)) {
                defaults.put(e.getKey(), e.getValue());
                continue;
            }
            requirements.put(e.getKey(), e.getValue());
        }
        return new OptionMap[]{defaults, requirements, conditions};
    }

    private Segment findSegment(List<Segment> segments, String key) {
        for (Segment seg : segments) {
            if (!seg.hasKey() || !key.equals(seg.getKey())) continue;
            return seg;
        }
        return null;
    }

    public OptionMap assignRouteOptions(List<Segment> segments, OptionMap defaults, OptionMap requirements) {
        OptionMap routeRequirements = OptionMap.of((Object[])new Object[0]);
        for (Map.Entry e : requirements.entrySet()) {
            String key = (String)e.getKey();
            Object requirement = e.getValue();
            Segment segment = this.findSegment(segments, key);
            if (segment != null) {
                segment.setRegexp((Pattern)requirement);
                continue;
            }
            routeRequirements.put((Object)key, requirement);
        }
        for (String key : defaults.keySet()) {
            String defaultValue = defaults.getString(key);
            Segment segment = this.findSegment(segments, key);
            if (segment == null) {
                throw new IllegalArgumentException(key + ": No matching segment exists; cannot assign default");
            }
            if (defaultValue != null) {
                segment.setOptional(true);
            }
            segment.setDefault(defaultValue);
        }
        this.assignDefaultRouteOptions(segments);
        this.ensureRequiredSegments(segments);
        return routeRequirements;
    }

    private void assignDefaultRouteOptions(List<Segment> segments) {
        for (Segment segment : segments) {
            if (!(segment instanceof DynamicSegment)) continue;
            String key = segment.getKey();
            if ("action".equals(key)) {
                segment.setDefault("index");
                segment.setOptional(true);
                continue;
            }
            if (!"id".equals(key)) continue;
            segment.setOptional(true);
        }
    }

    private void ensureRequiredSegments(List<Segment> segments) {
        boolean allowOptional = true;
        for (int i = segments.size() - 1; i >= 0; --i) {
            Segment segment = segments.get(i);
            boolean bl = allowOptional = allowOptional && segment.isOptional();
            if (!allowOptional && segment.isOptional()) {
                segment.setOptional(false);
                continue;
            }
            if (!allowOptional || !segment.hasDefault() || segment.getDefault() == null || !segment.getDefault().isEmpty()) continue;
            segment.setOptional(true);
        }
    }

    public Route build(String path, OptionMap options) {
        String prefix;
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        if ((prefix = options.getString("pathPrefix")) != null && !prefix.isEmpty()) {
            path = "/" + prefix.replace("^/", "") + path;
        }
        List<Segment> segments = this.segmentsForRoutePath(path);
        OptionMap[] extOptions = this.divideRouteOptions(segments, options);
        OptionMap requirements = this.assignRouteOptions(segments, extOptions[0], extOptions[1]);
        return new Route(segments, requirements, extOptions[2]);
    }

    private void validateRouteConditions(OptionMap conditions) {
        List methods = conditions.getList("method");
        for (Object m : methods) {
            String method = (String)m;
            if ("HEAD".equals(method)) {
                throw new IllegalArgumentException("HTTP method HEAD is invalid in route conditions.");
            }
            if (HTTP_METHODS.contains(method)) continue;
            throw new IllegalArgumentException("Invalid HTTP method specified in route conditions: " + conditions);
        }
    }
}

