/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing;

import enkan.collection.OptionMap;
import enkan.exception.MisconfigurationException;
import enkan.util.SearchUtils;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kotowari.routing.Recognizer;
import kotowari.routing.Route;
import kotowari.routing.factory.RoutePatterns;
import kotowari.routing.factory.RoutePatternsDescriptor;
import kotowari.routing.recognizer.OptimizedRecognizer;

public class Routes {
    private Recognizer recognizer;
    private List<Route> routeList;

    private Routes(List<Route> routeList) {
        this.routeList = routeList;
        this.recognizer = new OptimizedRecognizer();
    }

    public static RoutePatterns define(RoutePatternsDescriptor descriptor) {
        return Routes.define(null, descriptor);
    }

    public static RoutePatterns define(String prefix, RoutePatternsDescriptor descriptor) {
        RoutePatterns patterns = new RoutePatterns(prefix, routeList -> {
            Routes routes = new Routes((List<Route>)routeList);
            routes.recognizer.setRoutes((List<Route>)routeList);
            routes.recognizer.optimize();
            return routes;
        });
        descriptor.describe(patterns);
        return patterns;
    }

    public OptionMap recognizePath(String path, String method) {
        return this.recognizer.recognize(path, method);
    }

    public String generate(OptionMap options) {
        OptionMap merged = OptionMap.of((OptionMap)options);
        Class controller = (Class)options.get((Object)"controller");
        String action = options.getString("action");
        if (controller == null || action == null) {
            throw new MisconfigurationException("kotowari.ROUTING_GENERATION", new Object[0]);
        }
        return this.routeList.stream().filter(r -> r.matchesControllerAndAction(controller, action)).filter(r -> r.significantKeys().stream().allMatch(arg_0 -> options.containsKey(arg_0))).map(r -> r.generate(options, merged)).findFirst().orElseThrow(() -> new MisconfigurationException("kotowari.ROUTING_GENERATION", new Object[]{controller, action, this.routeList.stream().filter(r -> r.matchesController(controller)).map(Object::toString).collect(Collectors.joining("")), this.routeList.stream().filter(r -> r.matchesController(controller)).map(Route::getActionRequirement).sorted(Comparator.comparingInt(a -> SearchUtils.levenshteinDistance((CharSequence)a, (CharSequence)action))).findFirst().orElse("")}));
    }

    public String toString() {
        if (this.routeList == null) {
            return "[empty]";
        }
        StringBuilder out = new StringBuilder(1024);
        for (Route route : this.routeList) {
            out.append(route.toString());
        }
        return out.toString();
    }
}

