/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing.factory;

import enkan.collection.OptionMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import kotowari.routing.Route;
import kotowari.routing.RouteBuilder;
import kotowari.routing.Routes;
import kotowari.routing.factory.RoutePatternsDescriptor;
import kotowari.routing.factory.RoutingCondition;

public class RoutePatterns {
    private List<Route> routeList;
    private PatternsContext context;
    private RouteBuilder builder;
    private Function<List<Route>, Routes> routeCompiler;

    public RoutePatterns(String prefix, Function<List<Route>, Routes> routeCompiler) {
        this.routeCompiler = routeCompiler;
        this.routeList = new ArrayList<Route>();
        this.builder = new RouteBuilder();
        this.context = new PatternsContext(prefix, this);
    }

    RoutingCondition httpMethodCondition(String method, String path) {
        RoutingCondition cond = new RoutingCondition(method, path);
        cond.setContext(this.context);
        return cond;
    }

    public RoutingCondition get(String path) {
        return this.httpMethodCondition("GET", path);
    }

    public RoutingCondition post(String path) {
        return this.httpMethodCondition("POST", path);
    }

    public RoutingCondition put(String path) {
        return this.httpMethodCondition("PUT", path);
    }

    public RoutingCondition patch(String path) {
        return this.httpMethodCondition("PATCH", path);
    }

    public RoutingCondition delete(String path) {
        return this.httpMethodCondition("DELETE", path);
    }

    public Route resource(Class<?> controller) {
        return this.resource(controller, null);
    }

    private String decapitalize(String s) {
        if (s != null && s.length() > 1) {
            return Character.toLowerCase(s.charAt(0)) + s.substring(1);
        }
        return s;
    }

    public Route resource(Class<?> controller, OptionMap options) {
        String name = this.decapitalize(controller.getSimpleName().replaceAll("Controller$", ""));
        this.get(name + "/").to(controller, "index");
        this.get(name + "/:id").requires("id", "\\d+").to(controller, "show");
        this.get(name + "/new").to(controller, "newForm");
        this.post(name + "/").to(controller, "create");
        this.get(name + "/:id/edit").requires("id", "\\d+").to(controller, "edit");
        this.put(name + "/:id").requires("id", "\\d+").to(controller, "update");
        this.delete(name + "/:id").requires("id", "\\d+").to(controller, "delete");
        return null;
    }

    public void scope(String path, RoutePatternsDescriptor subDesc) {
        RoutePatterns subPatterns = Routes.define(this.context.joinPaths(path), subDesc);
        this.routeList.addAll(subPatterns.routeList);
    }

    private void addRoute_(Route route) {
        this.routeList.add(route);
    }

    private RouteBuilder getBuilder() {
        return this.builder;
    }

    public Routes compile() {
        return this.routeCompiler.apply(this.routeList);
    }

    static class PatternsContext {
        private String prefix;
        private RoutePatterns patterns;

        public PatternsContext(String prefix, RoutePatterns routes) {
            this.prefix = prefix;
            this.patterns = routes;
        }

        public void addRoute(Route route) {
            this.patterns.addRoute_(route);
        }

        String joinPaths(String path) {
            if (this.prefix == null) {
                return path;
            }
            return (this.prefix + "/" + path).replaceAll("//+", "/");
        }

        public Route build(String path, OptionMap options) {
            return this.patterns.getBuilder().build(this.joinPaths(path), options);
        }
    }
}

