/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing.factory;

import enkan.collection.OptionMap;
import java.util.regex.Pattern;
import kotowari.routing.Route;
import kotowari.routing.factory.RoutePatterns;

public class RoutingCondition {
    private String method;
    private String path;
    private OptionMap requirements;
    private RoutePatterns.PatternsContext context;

    public RoutingCondition(String method, String path) {
        this.method = method;
        this.path = path;
        this.requirements = OptionMap.empty();
    }

    public void setContext(RoutePatterns.PatternsContext context) {
        this.context = context;
    }

    public RoutingCondition requires(String patternVariable, String pattern) {
        this.requirements.put((Object)patternVariable, (Object)Pattern.compile(pattern));
        return this;
    }

    public Route to(Class<?> controllerClass, String controllerMethod) {
        OptionMap conditions = OptionMap.of((Object[])new Object[]{"method", this.method});
        OptionMap options = OptionMap.of((Object[])new Object[]{"controller", controllerClass, "action", controllerMethod, "conditions", conditions});
        if (!this.requirements.isEmpty()) {
            options.put((Object)"requirements", (Object)this.requirements);
        }
        Route route = this.context.build(this.path, options);
        this.context.addRoute(route);
        return route;
    }
}

