/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing.recognizer;

import enkan.collection.OptionMap;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kotowari.routing.Recognizer;
import kotowari.routing.RegexpUtils;
import kotowari.routing.Route;
import kotowari.routing.RouteBuilder;

public class OptimizedRecognizer
implements Recognizer {
    private SegmentNode tree;
    private List<Route> routes;

    public String[] toPlainSegments(String str) {
        str = str.replaceAll("^/+", "").replaceAll("/+$", "");
        return str.split("\\.[^/]+/+|[" + RegexpUtils.escape(String.join((CharSequence)"", RouteBuilder.SEPARATORS)) + "]+|\\.[^/]+\\Z");
    }

    @Override
    public void setRoutes(List<Route> routes) {
        this.routes = routes;
        this.optimize();
    }

    @Override
    public boolean isOptimized() {
        return this.tree != null;
    }

    @Override
    public void optimize() {
        this.tree = new SegmentNode(0);
        int i = -1;
        for (Route route : this.routes) {
            String[] segments;
            ++i;
            SegmentNode node = this.tree;
            for (String seg : segments = this.toPlainSegments(String.join((CharSequence)"", route.getSegments().stream().map(Object::toString).collect(Collectors.toList())))) {
                if (!seg.isEmpty() && seg.charAt(0) == ':') {
                    seg = ":dynamic";
                }
                if (node.isEmpty() || !seg.equals(node.lastChild().getLabel())) {
                    node.add(new SegmentNode(seg, i));
                }
                node = node.lastChild();
            }
        }
    }

    private int calcIndex(String[] segments, SegmentNode node, int level) {
        if (node.size() <= 1 || segments.length == level) {
            return node.getIndex();
        }
        String seg = segments[level];
        for (SegmentNode item : node.getChildNodes()) {
            if (!":dynamic".equals(item.getLabel()) && !seg.equals(item.getLabel())) continue;
            return this.calcIndex(segments, item, level + 1);
        }
        return node.getIndex();
    }

    @Override
    public OptionMap recognize(String path, String method) {
        String[] segments = this.toPlainSegments(path);
        for (int index = this.calcIndex(segments, this.tree, 0); index < this.routes.size(); ++index) {
            OptionMap result = this.routes.get(index).recognize(path, method);
            if (result == null) continue;
            return result;
        }
        return OptionMap.of((Object[])new Object[0]);
    }

    private class SegmentNode {
        private int index;
        private String label;
        private List<SegmentNode> childNodes;

        public SegmentNode(int index) {
            this(null, index);
        }

        public SegmentNode(String label, int index) {
            this.index = index;
            this.label = label;
            this.childNodes = new ArrayList<SegmentNode>();
        }

        public void add(SegmentNode child) {
            this.childNodes.add(child);
        }

        public boolean isEmpty() {
            return this.childNodes.isEmpty();
        }

        public SegmentNode lastChild() {
            if (this.isEmpty()) {
                return null;
            }
            return this.childNodes.get(this.childNodes.size() - 1);
        }

        public String getLabel() {
            return this.label;
        }

        public int getIndex() {
            return this.index;
        }

        public List<SegmentNode> getChildNodes() {
            return this.childNodes;
        }

        public int size() {
            return this.childNodes.size();
        }
    }
}

