/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing.segment;

import enkan.collection.OptionMap;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotowari.routing.RegexpUtils;
import kotowari.routing.RouteBuilder;
import kotowari.routing.Segment;

public class DynamicSegment
extends Segment {
    private String key;
    private String defaultValue;
    private Pattern regexp;
    private boolean wrapParentheses = false;

    public DynamicSegment(String key) {
        this(key, new OptionMap());
    }

    public DynamicSegment(String key, OptionMap options) {
        this.key = key;
        if (options.containsKey((Object)"default")) {
            this.defaultValue = options.getString("default");
        }
        if (options.containsKey((Object)"regexp")) {
            this.regexp = Pattern.compile(options.getString("regexp"));
        }
        if (options.containsKey((Object)"wrapParentheses")) {
            this.wrapParentheses = options.getBoolean("wrapParentheses");
        }
    }

    public String toString() {
        return this.wrapParentheses ? "(:" + this.key + ")" : ":" + this.key;
    }

    @Override
    public boolean hasKey() {
        return true;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String regexpChunk() {
        return this.regexp != null ? "(" + this.regexp.pattern() + ")" : this.defaultRegexpChunk();
    }

    public String defaultRegexpChunk() {
        return "([^" + RegexpUtils.escape(String.join((CharSequence)"", RouteBuilder.SEPARATORS)) + "]+)";
    }

    @Override
    public boolean hasDefault() {
        return true;
    }

    @Override
    public String getDefault() {
        return this.defaultValue;
    }

    @Override
    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setRegexp(Pattern regexp) {
        this.regexp = regexp;
    }

    @Override
    public void matchExtraction(OptionMap params, Matcher match, int nextCapture) {
        String value;
        String m = match.group(nextCapture);
        if (m != null) {
            try {
                value = URLEncoder.encode(m, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                value = m;
            }
        } else {
            value = this.defaultValue;
        }
        params.put((Object)this.key, (Object)value);
    }

    @Override
    public String buildPattern(String pattern) {
        pattern = this.regexpChunk() + pattern;
        return this.isOptional() ? RegexpUtils.optionalize(pattern) : pattern;
    }

    @Override
    public String interpolationChunk(OptionMap hash) {
        String value = hash.getString(this.getKey());
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    @Override
    public String stringStructure(List<Segment> list, OptionMap hash) {
        if (this.isOptional()) {
            if (hash.getString(this.getKey()).equals(this.getDefault())) {
                return this.continueStringStructure(list, hash);
            }
            return this.interpolationStatement(list, hash);
        }
        return this.interpolationStatement(list, hash);
    }
}

