/*
 * Decompiled with CFR 0.152.
 */
package kotowari.routing.segment;

import enkan.collection.OptionMap;
import kotowari.routing.RegexpUtils;
import kotowari.routing.Segment;

public class StaticSegment
extends Segment {
    private boolean raw;

    public StaticSegment(String value) {
        this(value, OptionMap.of((Object[])new Object[0]));
    }

    public StaticSegment(String value, OptionMap options) {
        super(value);
        if (options.containsKey((Object)"raw")) {
            this.raw = options.getBoolean("raw");
        }
        if (options.containsKey((Object)"optional")) {
            this.setOptional(options.getBoolean("optional"));
        }
    }

    @Override
    public String interpolationChunk(OptionMap hash) {
        return this.raw ? this.getValue() : super.interpolationChunk(hash);
    }

    @Override
    public String regexpChunk() {
        String chunk = RegexpUtils.escape(this.getValue());
        return this.isOptional() ? RegexpUtils.optionalize(chunk) : chunk;
    }

    @Override
    public int numberOfCaptures() {
        return 0;
    }

    @Override
    public String buildPattern(String pattern) {
        String escaped = RegexpUtils.escape(this.getValue());
        if (this.isOptional() && !pattern.isEmpty()) {
            return "(?:" + RegexpUtils.optionalize(escaped) + "\\Z|" + escaped + RegexpUtils.unoptionalize(pattern) + ")";
        }
        if (this.isOptional()) {
            return RegexpUtils.optionalize(escaped);
        }
        return escaped + pattern;
    }

    public String toString() {
        return this.getValue();
    }
}

