/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.unit8.http.router.ARStringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Options
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;

    public Options() {
    }

    public Options(Map<String, Object> options) {
        super(options);
    }

    public static Options newInstance() {
        return new Options();
    }

    public Options $(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public String getString(String key) {
        Object value = this.get(key);
        return value == null ? "" : value.toString();
    }

    public String getUrlEncodedString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return "";
        }
        if (value instanceof Collection) {
            Collection values = (Collection)Collection.class.cast(value);
            ArrayList<String> pairs = new ArrayList<String>(values.size());
            for (Object val : values) {
                if (val == null) {
                    val = "";
                }
                pairs.add(ARStringUtil.urlencode(key) + "=" + ARStringUtil.urlencode(val.toString()));
            }
            return ARStringUtil.join(pairs, "&");
        }
        return ARStringUtil.urlencode(key) + "=" + ARStringUtil.urlencode(value.toString());
    }

    public List<Object> getList(String key) {
        List<Object> valueList;
        Object value = this.get(key);
        if (value == null) {
            return new ArrayList<Object>();
        }
        if (List.class.isAssignableFrom(value.getClass())) {
            valueList = (List<Object>)value;
        } else if (value.getClass().isArray()) {
            valueList = Arrays.asList((Object[])value);
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            valueList = new ArrayList<Object>((Collection)Collection.class.cast(value));
        } else {
            valueList = new ArrayList<Object>(1);
            valueList.add(value);
        }
        return valueList;
    }

    public Options except(String ... keys) {
        Options copy = new Options(this);
        for (String key : keys) {
            copy.remove(key);
        }
        return copy;
    }

    public boolean getBoolean(String key) {
        Object value = this.get(key);
        return value != null && (value instanceof Boolean && (Boolean)value != false || value instanceof Number && ((Number)value).intValue() == 1 || ARStringUtil.equals(value.toString(), "true"));
    }

    public Options takeoutOptions(String key) {
        Object obj = this.remove(key);
        if (obj instanceof Options) {
            return (Options)obj;
        }
        return new Options();
    }

    public String toQueryString() {
        StringBuilder queryString = new StringBuilder(512);
        for (String key : this.keySet()) {
            if (ARStringUtil.equals(key, "controller") || ARStringUtil.equals(key, "action")) continue;
            queryString.append(ARStringUtil.urlencode(key)).append('=').append(ARStringUtil.urlencode(this.getString(key)));
        }
        return queryString.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256).append("{ ");
        for (Map.Entry entry : this.entrySet()) {
            sb.append(":").append((String)entry.getKey()).append(" => '").append(entry.getValue() == null ? "null" : entry.getValue().toString()).append("', ");
        }
        if (sb.toString().endsWith(", ")) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append(" }");
        return sb.toString();
    }

    @Override
    public boolean equals(Object another) {
        if (another == null || !(another instanceof Options)) {
            return false;
        }
        Options anotherOptions = (Options)another;
        if (anotherOptions.keySet().size() != this.keySet().size()) {
            return false;
        }
        for (String key : this.keySet()) {
            Object thisValue;
            Object anotherValue = anotherOptions.get(key);
            if (anotherValue == (thisValue = this.get(key)) || thisValue != null && thisValue.equals(anotherValue)) continue;
            return false;
        }
        return true;
    }
}

