/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.Segment;
import net.unit8.http.router.segment.DividerSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Route {
    private List<Segment> segments;
    private Options requirements;
    private Options conditions;
    private List<String> significantKeys;
    private Options parameterShell;
    private boolean matchingPrepared;
    private String controllerRequirement;
    private String actionRequirement;
    private Pattern recognizePattern;

    public Route(List<Segment> segments, Options requirements, Options conditions) {
        this.segments = segments;
        this.requirements = requirements;
        this.conditions = conditions;
        if (!this.significantKeys().contains("action") && !requirements.containsKey("action")) {
            requirements.$("action", "index");
            this.significantKeys().add("action");
        }
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public String buildQueryString(Map<String, String> hash) {
        ArrayList<String> elements = new ArrayList<String>();
        for (String key : hash.keySet()) {
            String value = hash.get(key);
            if (ARStringUtil.isEmpty(value)) continue;
            elements.add(key + "=" + value);
        }
        return ARStringUtil.join(elements, "&");
    }

    public List<String> significantKeys() {
        if (this.significantKeys != null) {
            return this.significantKeys;
        }
        HashSet<String> sk = new HashSet<String>();
        for (Segment segment : this.segments) {
            if (!segment.hasKey()) continue;
            sk.add(segment.getKey());
        }
        sk.addAll(this.requirements.keySet());
        this.significantKeys = new ArrayList<String>(sk);
        return this.significantKeys;
    }

    public String toString() {
        StringBuilder segs = new StringBuilder();
        for (Segment s : this.segments) {
            segs.append(s.toString());
        }
        List<Object> methods = this.conditions.getList("method");
        if (methods.isEmpty()) {
            methods.add("any");
        }
        StringBuilder out = new StringBuilder(256);
        for (Object method : methods) {
            out.append(String.format("%-6s %-40s %s\n", method.toString().toUpperCase(), segs.toString(), this.requirements));
        }
        return out.toString();
    }

    public Options recognize(String path, String method) {
        List<Object> methods = this.conditions.getList("method");
        if (!methods.isEmpty() && !methods.contains(method)) {
            return null;
        }
        if (this.recognizePattern == null) {
            this.recognizePattern = Pattern.compile(this.recognitionPattern(true));
        }
        Matcher match = this.recognizePattern.matcher(path);
        Options params = null;
        if (match.find()) {
            int nextCapture = 1;
            params = new Options(this.getParameterShell());
            for (Segment segment : this.segments) {
                segment.matchExtraction(params, match, nextCapture);
                nextCapture += segment.numberOfCaptures();
            }
        }
        return params;
    }

    private String recognitionPattern(boolean wrap) {
        String pattern = "";
        for (int i = this.segments.size() - 1; i >= 0; --i) {
            Segment segment = this.segments.get(i);
            pattern = segment.buildPattern(pattern);
        }
        return wrap ? "\\A" + pattern + "\\Z" : pattern;
    }

    private String buildQueryString(Options hash, List<String> onlyKeys) {
        ArrayList<String> elements = new ArrayList<String>(hash.size());
        if (onlyKeys == null) {
            onlyKeys = new ArrayList(hash.keySet());
        }
        for (String key : onlyKeys) {
            if (!hash.containsKey(key)) continue;
            elements.add(hash.getUrlEncodedString(key));
        }
        return elements.isEmpty() ? "" : "?" + ARStringUtil.join(elements, "&");
    }

    private Options getParameterShell() {
        if (this.parameterShell == null) {
            Options options = new Options();
            for (Map.Entry e : this.requirements.entrySet()) {
                if (e.getValue() instanceof Pattern) continue;
                options.put(e.getKey(), e.getValue());
            }
            this.parameterShell = options;
        }
        return this.parameterShell;
    }

    public boolean matchesControllerAndAction(String controller, String action) {
        this.prepareMatching();
        return !(this.controllerRequirement != null && !ARStringUtil.equals(this.controllerRequirement, controller) || this.actionRequirement != null && !ARStringUtil.equals(this.actionRequirement, action));
    }

    public String generate(Options options, Options hash) {
        if (this.generationRequirements(options, hash)) {
            int lastIndex = this.segments.size() - 1;
            Segment last = this.segments.get(lastIndex);
            String path = last.stringStructure(this.segments.subList(0, lastIndex), hash);
            if (this.segments.size() > 1 && last instanceof DividerSegment && ARStringUtil.equals(last.getValue(), "/")) {
                path = path + "/";
            }
            return this.appendQueryString(path, hash, this.extraKeys(options));
        }
        return null;
    }

    public boolean generationRequirements(Options options, Options hash) {
        boolean matched = true;
        for (String key : this.requirements.keySet()) {
            Object req = this.requirements.get(key);
            if (req instanceof Pattern) {
                matched &= hash.containsKey(key) && ((Pattern)req).matcher(options.getString(key)).matches();
                continue;
            }
            matched &= ARStringUtil.equals(hash.getString(key), this.requirements.getString(key));
        }
        return matched;
    }

    private String requirementFor(String key) {
        if (this.requirements.containsKey(key)) {
            return this.requirements.getString(key);
        }
        for (Segment segment : this.segments) {
            if (!segment.hasKey() || !ARStringUtil.equals(segment.getKey(), key)) continue;
            return segment.getRegexp();
        }
        return null;
    }

    private void prepareMatching() {
        if (!this.matchingPrepared) {
            this.controllerRequirement = this.requirementFor("controller");
            this.actionRequirement = this.requirementFor("action");
            this.matchingPrepared = true;
        }
    }

    private String appendQueryString(String path, Options hash, List<String> queryKeys) {
        if (path == null) {
            return null;
        }
        if (queryKeys == null) {
            queryKeys = this.extraKeys(hash);
        }
        return path + this.buildQueryString(hash, queryKeys);
    }

    private List<String> extraKeys(Options hash) {
        ArrayList<String> extraKeys = new ArrayList<String>();
        if (hash != null) {
            for (String key : hash.keySet()) {
                if (this.significantKeys.contains(key)) continue;
                extraKeys.add(key);
            }
        }
        return extraKeys;
    }
}

