/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.RegexpUtil;
import net.unit8.http.router.Route;
import net.unit8.http.router.Routes;
import net.unit8.http.router.Segment;
import net.unit8.http.router.segment.ControllerSegment;
import net.unit8.http.router.segment.DividerSegment;
import net.unit8.http.router.segment.DynamicSegment;
import net.unit8.http.router.segment.OptionalFormatSegment;
import net.unit8.http.router.segment.PathSegment;
import net.unit8.http.router.segment.StaticSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteBuilder {
    public static final String[] SEPARATORS = new String[]{"/", ".", "?", "(", ")"};
    private static final Pattern PTN_OPTIONAL_FORMAT = Pattern.compile("\\A\\.(:format?)\\/");
    private static final Pattern PTN_SYMBOL = Pattern.compile("\\A(?::(\\w+)|\\(:(\\w+)\\))");
    private static final Pattern PTN_PATH = Pattern.compile("\\A\\*(\\w+)");
    private static final Pattern PTN_STATIC = Pattern.compile("\\A\\?(.*?)\\?");
    private List<String> optionalSeparators = Collections.singletonList("/");
    private Pattern separatorRegexp = Pattern.compile("[" + RegexpUtil.escape(ARStringUtil.join(SEPARATORS)) + "]");
    private Pattern nonseparatorRegexp = Pattern.compile("\\A([^" + RegexpUtil.escape(ARStringUtil.join(SEPARATORS)) + "]+)");

    public List<Segment> segmentsForRoutePath(String path) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        StringBuilder rest = new StringBuilder(path);
        while (rest.length() > 0) {
            Segment segment = this.segmentFor(rest);
            segments.add(segment);
        }
        return segments;
    }

    public Segment segmentFor(StringBuilder sb) {
        String str = sb.toString();
        Segment segment = null;
        Matcher m = PTN_OPTIONAL_FORMAT.matcher(str);
        if (m.find()) {
            segment = new OptionalFormatSegment();
        } else {
            m = PTN_SYMBOL.matcher(str);
            if (m.find()) {
                Options options = new Options();
                String key = m.group(1);
                if (ARStringUtil.isEmpty(key)) {
                    key = m.group(2);
                    options.$("wrapParentheses", true);
                }
                segment = ARStringUtil.equals(key, "controller") ? new ControllerSegment(key, options) : new DynamicSegment(key, options);
            } else {
                m = PTN_PATH.matcher(str);
                if (m.find()) {
                    segment = new PathSegment(m.group(1), new Options().$("optional", true));
                } else {
                    m = PTN_STATIC.matcher(str);
                    if (m.find()) {
                        segment = new StaticSegment(m.group(1), new Options().$("optional", true));
                    } else {
                        m = this.nonseparatorRegexp.matcher(str);
                        if (m.find()) {
                            segment = new StaticSegment(m.group(1));
                        } else {
                            m = this.separatorRegexp.matcher(str);
                            if (m.find()) {
                                segment = new DividerSegment(m.group(), new Options().$("optional", this.optionalSeparators.contains(m.group())));
                            }
                        }
                    }
                }
            }
        }
        sb.delete(0, m.end());
        return segment;
    }

    public Options[] divideRouteOptions(List<Segment> segments, Options options) {
        if ((options = options.except("pathPrefix", "namePrefix")).containsKey("namespace")) {
            String namespace = options.getString("namespace").replace("/$", "");
            options.remove("namespace");
            options.put("controller", namespace.replace('/', '.') + "." + options.get("controller"));
        }
        Options requirements = options.takeoutOptions("requirements");
        Options defaults = options.takeoutOptions("defaults");
        Options conditions = options.takeoutOptions("conditions");
        this.validateRouteConditions(conditions);
        ArrayList<String> pathKeys = new ArrayList<String>();
        for (Segment segment : segments) {
            if (!segment.hasKey()) continue;
            pathKeys.add(segment.getKey());
        }
        for (Map.Entry entry : options.entrySet()) {
            if (pathKeys.contains(entry.getKey()) && !(entry.getValue() instanceof Pattern)) {
                defaults.put(entry.getKey(), entry.getValue());
                continue;
            }
            requirements.put(entry.getKey(), entry.getValue());
        }
        return new Options[]{defaults, requirements, conditions};
    }

    private Segment findSegment(List<Segment> segments, String key) {
        for (Segment seg : segments) {
            if (!seg.hasKey() || !ARStringUtil.equals(key, seg.getKey())) continue;
            return seg;
        }
        return null;
    }

    public Options assignRouteOptions(List<Segment> segments, Options defaults, Options requirements) {
        Options routeRequirements = new Options();
        for (Map.Entry e : requirements.entrySet()) {
            String key = (String)e.getKey();
            Object requirement = e.getValue();
            Segment segment = this.findSegment(segments, key);
            if (segment != null) {
                segment.setRegexp((Pattern)requirement);
                continue;
            }
            routeRequirements.put(key, requirement);
        }
        for (String key : defaults.keySet()) {
            String defaultValue = defaults.getString(key);
            Segment segment = this.findSegment(segments, key);
            if (segment == null) {
                throw new IllegalArgumentException(key + ": No matching segment exists; cannot assign default");
            }
            if (defaultValue != null) {
                segment.setOptional(true);
            }
            segment.setDefault(defaultValue);
        }
        this.assignDefaultRouteOptions(segments);
        this.ensureRequiredSegments(segments);
        return routeRequirements;
    }

    private void assignDefaultRouteOptions(List<Segment> segments) {
        for (Segment segment : segments) {
            if (!(segment instanceof DynamicSegment)) continue;
            String key = segment.getKey();
            if (ARStringUtil.equals(key, "action")) {
                segment.setDefault("index");
                segment.setOptional(true);
                continue;
            }
            if (!ARStringUtil.equals(key, "id")) continue;
            segment.setOptional(true);
        }
    }

    private void ensureRequiredSegments(List<Segment> segments) {
        boolean allowOptional = true;
        for (int i = segments.size() - 1; i >= 0; --i) {
            Segment segment = segments.get(i);
            boolean bl = allowOptional = allowOptional && segment.isOptional();
            if (!allowOptional && segment.isOptional()) {
                segment.setOptional(false);
                continue;
            }
            if (!allowOptional || !segment.hasDefault() || ARStringUtil.isEmpty(segment.getDefault())) continue;
            segment.setOptional(true);
        }
    }

    public Route build(String path, Options options) {
        String prefix;
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        if (!ARStringUtil.isEmpty(prefix = options.getString("pathPrefix").replace("^/", ""))) {
            path = "/" + prefix + path;
        }
        List<Segment> segments = this.segmentsForRoutePath(path);
        Options[] extOptions = this.divideRouteOptions(segments, options);
        Options requirements = this.assignRouteOptions(segments, extOptions[0], extOptions[1]);
        return new Route(segments, requirements, extOptions[2]);
    }

    private void validateRouteConditions(Options conditions) {
        List<Object> methods = conditions.getList("method");
        for (Object m : methods) {
            String method = (String)m;
            if (ARStringUtil.equals(method, "HEAD")) {
                throw new IllegalArgumentException("HTTP method HEAD is invalid in route conditions.");
            }
            if (Routes.HTTP_METHODS.contains(method)) continue;
            throw new IllegalArgumentException("Invalid HTTP method specified in route conditions: " + conditions);
        }
    }
}

