/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.Route;
import net.unit8.http.router.RouteBuilder;
import net.unit8.http.router.Routes;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteLoader
extends DefaultHandler {
    private String controller = null;
    private Stack<String> pathScope = new Stack();
    private Stack<String> moduleScope = new Stack();
    private Locator locator;
    private RouteBuilder builder;
    private Options options;
    private String path;
    private List<Route> routes = new ArrayList<Route>();

    public RouteLoader(RouteBuilder builder) {
        this.builder = builder;
    }

    public List<Route> load(File config) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(config);
            List<Route> list = this.load(in);
            return list;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public List<Route> load(InputStream stream) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(new InputSource(stream), (DefaultHandler)this);
            return this.routes;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("match") || Routes.HTTP_METHODS.contains(qName.toUpperCase())) {
            this.path = attributes.getValue("path");
            if (ARStringUtil.isEmpty(this.path)) {
                throw new SAXParseException("Can't find path in match.", this.locator);
            }
            this.options = this.processAttributes(attributes);
            if (!qName.equalsIgnoreCase("match")) {
                Options conditions = (Options)this.options.get("conditions");
                if (conditions == null) {
                    conditions = new Options();
                    this.options.put("conditions", conditions);
                }
                conditions.$("method", qName.toUpperCase());
            }
        } else if (qName.equalsIgnoreCase("controller")) {
            this.controller = attributes.getValue("name");
            if (ARStringUtil.isEmpty(this.controller)) {
                throw new SAXParseException("Can't find controller name.", this.locator);
            }
        } else if (qName.equalsIgnoreCase("root")) {
            Options options = this.processAttributes(attributes);
            this.routes.add(this.builder.build("/", options));
        } else if (qName.equalsIgnoreCase("namespace")) {
            String name = attributes.getValue("name");
            if (ARStringUtil.isEmpty(name)) {
                throw new SAXParseException("Can't find namespace's name.", this.locator);
            }
            this.pathScope.push(name);
            this.moduleScope.push(name);
        } else if (qName.equalsIgnoreCase("scope")) {
            String name = ARStringUtil.defaultIfEmpty(attributes.getValue("name"), "");
            String module = ARStringUtil.defaultIfEmpty(attributes.getValue("module"), "");
            if (ARStringUtil.isEmpty(name) && ARStringUtil.isEmpty(module)) {
                throw new SAXParseException("Scope must have any attributes, name or module.", this.locator);
            }
            this.pathScope.push(name);
            this.moduleScope.push(module);
        } else if (qName.equalsIgnoreCase("requirements")) {
            this.options.$("requirements", new Options());
        } else if (qName.equalsIgnoreCase("requirement")) {
            Options requirements = (Options)this.options.get("requirements");
            if (requirements == null) {
                throw new SAXParseException("Requirement must be in the requirements.", this.locator);
            }
            String name = attributes.getValue("name");
            String value = attributes.getValue("value");
            requirements.$(name, Pattern.compile(value));
        } else if (qName.equalsIgnoreCase("defaults")) {
            this.options.$("defaults", new Options());
        } else if (qName.equalsIgnoreCase("default")) {
            Options defaults = (Options)this.options.get("defaults");
            if (defaults == null) {
                throw new SAXParseException("Default must be in the defaults.", this.locator);
            }
            String name = attributes.getValue("name");
            String value = attributes.getValue("value");
            defaults.$(name, value);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equalsIgnoreCase("match") || Routes.HTTP_METHODS.contains(qName.toUpperCase())) {
            this.routes.add(this.builder.build(this.path, this.options));
            this.options = null;
        } else if (qName.equalsIgnoreCase("controller")) {
            this.controller = null;
        } else if (qName.equalsIgnoreCase("namespace") || qName.equalsIgnoreCase("scope")) {
            this.pathScope.pop();
            this.moduleScope.pop();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    private Options processAttributes(Attributes attributes) {
        String namespace;
        String pathPrefix;
        int attrLen = attributes.getLength();
        Options options = new Options();
        for (int i = 0; i < attrLen; ++i) {
            String optionName = attributes.getQName(i);
            if (ARStringUtil.equals(optionName, "path")) continue;
            if (ARStringUtil.equals(optionName, "to")) {
                String[] tokens = attributes.getValue(i).split("#", 2);
                if (tokens.length == 1) {
                    options.$("action", tokens[0]);
                    continue;
                }
                options.$("controller", tokens[0]).$("action", tokens[1]);
                continue;
            }
            if (ARStringUtil.equals(optionName, "via")) {
                String[] methods;
                for (String method : methods = attributes.getValue(i).split(",")) {
                    List<Object> methodList;
                    if (!Routes.HTTP_METHODS.contains(method.trim().toUpperCase())) continue;
                    Options conditions = (Options)options.get("conditions");
                    if (conditions == null) {
                        conditions = new Options();
                        options.put("conditions", conditions);
                    }
                    if (!conditions.containsKey("method")) {
                        methodList = new ArrayList();
                        conditions.$("method", methodList);
                    } else {
                        methodList = conditions.getList("method");
                    }
                    methodList.add(method.trim().toUpperCase());
                }
                continue;
            }
            options.put(optionName, attributes.getValue(i));
        }
        if (this.controller != null) {
            options.put("controller", this.controller);
        }
        if (!(this.pathScope.empty() || ARStringUtil.isEmpty(pathPrefix = ARStringUtil.strip(ARStringUtil.join(this.pathScope, '/').replaceAll("/+", "/"), "/")) || ARStringUtil.equals(pathPrefix, "/"))) {
            options.put("pathPrefix", pathPrefix);
        }
        if (!(this.moduleScope.empty() || ARStringUtil.isEmpty(namespace = ARStringUtil.strip(ARStringUtil.join(this.moduleScope, '/').replaceAll("/+", "/"), "/")) || ARStringUtil.equals(namespace, "/"))) {
            options.put("namespace", namespace);
        }
        return options;
    }
}

