/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.Recognizer;
import net.unit8.http.router.Route;
import net.unit8.http.router.RouteBuilder;
import net.unit8.http.router.RouteLoader;
import net.unit8.http.router.RoutingException;
import net.unit8.http.router.recognizer.OptimizedRecognizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RouteSet {
    private TreeSet<File> configurationFiles;
    private List<Route> routes;
    private RouteBuilder builder = new RouteBuilder();
    private Recognizer recognizer;
    private Map<String, Map<String, List<Route>>> routesByController;

    public RouteSet() {
        this.routes = new ArrayList<Route>();
        this.configurationFiles = new TreeSet();
        this.routesByController = new HashMap<String, Map<String, List<Route>>>();
        this.recognizer = new OptimizedRecognizer();
    }

    public void clear() {
        this.routes.clear();
        this.routesByController.clear();
    }

    public void addConfigurationFile(File file) {
        this.configurationFiles.add(file);
    }

    public Set<File> getConfigurationFiles() {
        return this.configurationFiles;
    }

    public void load() {
        this.clear();
        this.loadRoutes();
    }

    public void loadStream(InputStream stream) {
        this.clear();
        this.routes = new RouteLoader(this.builder).load(stream);
        this.recognizer.setRoutes(this.routes);
    }

    private void loadRoutes() {
        if (!this.configurationFiles.isEmpty()) {
            for (File config : this.configurationFiles) {
                this.routes = new RouteLoader(this.builder).load(config);
            }
        } else {
            this.addRoute(":controller/:action/:id", new Options());
        }
        this.recognizer.setRoutes(this.routes);
    }

    public Route addRoute(String path, Options options) {
        Route route = this.builder.build(path, options);
        this.routes.add(route);
        return route;
    }

    public Options recognizePath(String path, String method) {
        if (!this.recognizer.isOptimized()) {
            this.recognizer.setRoutes(this.routes);
        }
        return this.recognizer.recognize(path, method);
    }

    public String generate(Options options) {
        Options merged = new Options(options);
        String controller = merged.getString("controller");
        String action = merged.getString("action");
        if (ARStringUtil.isEmpty(controller) || ARStringUtil.isEmpty(action)) {
            throw new RoutingException("Need controller and action!");
        }
        List<Route> routes = this.routesByController(controller, action);
        for (Route route : routes) {
            String results;
            if (!this.hasAllKey(route, options) || ARStringUtil.isEmpty(results = route.generate(options, merged))) continue;
            return results;
        }
        throw new RoutingException("No route matches " + options.toString());
    }

    private boolean hasAllKey(Route route, Options options) {
        for (String key : route.significantKeys()) {
            if (options.containsKey(key)) continue;
            return false;
        }
        return true;
    }

    private List<Route> routesByController(String controller, String action) {
        List<Route> routesByAction;
        Map<String, List<Route>> actionMap = this.routesByController.get(controller);
        if (actionMap == null) {
            actionMap = new HashMap<String, List<Route>>();
            this.routesByController.put(controller, actionMap);
        }
        if ((routesByAction = actionMap.get(action)) == null) {
            routesByAction = new ArrayList<Route>();
            for (Route route : this.routes) {
                if (!route.matchesControllerAndAction(controller, action)) continue;
                routesByAction.add(route);
            }
            actionMap.put(action, routesByAction);
        }
        return routesByAction;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(1024);
        for (Route route : this.routes) {
            out.append(route.toString());
        }
        return out.toString();
    }
}

