/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.unit8.http.router.ControllerDetector;
import net.unit8.http.router.CurrentControllerFinder;
import net.unit8.http.router.Options;
import net.unit8.http.router.RouteSet;
import net.unit8.http.router.detector.NopControllerDetector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Routes {
    private static volatile List<String> possibleControllers = null;
    private static RouteSet routeSet = new RouteSet();
    private static ControllerDetector controllerDetector;
    static CurrentControllerFinder currentControllerFinder;
    public static final List<String> HTTP_METHODS;

    public static String generate(Options options) {
        return Routes.getRouteSet().generate(options);
    }

    public static Options recognizePath(String path) {
        return Routes.recognizePath(path, "GET");
    }

    public static Options recognizePath(String path, String method) {
        return Routes.getRouteSet().recognizePath(path, method);
    }

    public static void load(InputStream stream) {
        Routes.getRouteSet().loadStream(stream);
    }

    public static void load(File config) {
        Routes.getRouteSet().getConfigurationFiles().clear();
        Routes.getRouteSet().addConfigurationFile(config);
        Routes.getRouteSet().load();
    }

    public static synchronized RouteSet getRouteSet() {
        return routeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized List<String> possibleControllers() {
        if (possibleControllers != null) return possibleControllers;
        Class<Routes> clazz = Routes.class;
        synchronized (Routes.class) {
            if (possibleControllers != null) return possibleControllers;
            possibleControllers = controllerDetector.detect();
            // ** MonitorExit[var0] (shouldn't be in output)
            return possibleControllers;
        }
    }

    static {
        HTTP_METHODS = Collections.unmodifiableList(Arrays.asList("GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "OPTIONS"));
        InputStream is = Routes.class.getResourceAsStream("routes.properties");
        if (is == null) {
            controllerDetector = new NopControllerDetector();
        } else {
            Properties props = new Properties();
            try {
                String finderClassName;
                props.load(is);
                String detectorClassName = props.getProperty("router.controllerDetector");
                if (detectorClassName != null) {
                    controllerDetector = (ControllerDetector)Class.forName(detectorClassName).newInstance();
                }
                if ((finderClassName = props.getProperty("router.currentControllerFinder")) != null) {
                    currentControllerFinder = (CurrentControllerFinder)Class.forName(finderClassName).newInstance();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (controllerDetector == null) {
                controllerDetector = new NopControllerDetector();
            }
        }
    }
}

