/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router;

import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.Routes;
import net.unit8.http.router.RoutingException;
import net.unit8.http.router.UrlRewriter;

public class RoutingTestUtil {
    public static void assertGenerates(String expected, String optionString) {
        Options options = UrlRewriter.parseOptionString(optionString);
        String actual = Routes.generate(options);
        if (!ARStringUtil.equals(expected, actual)) {
            RoutingTestUtil.fail(RoutingTestUtil.format(null, expected, actual));
        }
    }

    public static void assertRecognizes(String optionString, String path) {
        Options expected = UrlRewriter.parseOptionString(optionString);
        Options actual = null;
        try {
            actual = Routes.recognizePath(path);
        }
        catch (RoutingException routingException) {
            // empty catch block
        }
        if (!expected.equals(actual)) {
            RoutingTestUtil.fail(RoutingTestUtil.format(null, expected, actual));
        }
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static String format(String message, Object expected, Object actual) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        return formatted + "expected:<" + expected + "> but was:<" + actual + ">";
    }
}

