/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router;

import java.util.ArrayList;
import java.util.Map;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.ControllerUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.Routes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlRewriter {
    public static String contextPath = null;

    public static String urlFor(Map<String, Object> opts) {
        Options options = new Options(opts);
        return UrlRewriter.urlFor(options);
    }

    public static String urlFor(String optionString) {
        Options options = UrlRewriter.parseOptionString(optionString);
        return UrlRewriter.urlFor(options);
    }

    public static String urlFor(Options options) {
        StringBuilder url = new StringBuilder();
        boolean trailingSlash = false;
        if (options.containsKey("trailing_slash")) {
            trailingSlash = options.getBoolean("trailing_slash");
            options.remove("trailing_slash");
        }
        String anchor = null;
        if (options.containsKey("anchor")) {
            anchor = "#" + ARStringUtil.urlencode(options.getString("anchor"));
            options.remove("anchor");
        }
        if (!options.getBoolean("skip_context_path") && !ARStringUtil.isEmpty(contextPath)) {
            url.append(contextPath);
            options.remove("skip_context_path");
        }
        String generated = Routes.generate(options);
        String path = trailingSlash ? UrlRewriter.trailingSlash(generated) : generated;
        url.append(path);
        if (!ARStringUtil.isEmpty(anchor)) {
            url.append(anchor);
        }
        return url.toString();
    }

    private static String trailingSlash(String url) {
        int queryStringIdx = url.indexOf(63);
        if (queryStringIdx < 0 || url.length() < 1) {
            return url + "/";
        }
        if (queryStringIdx != 0 && url.charAt(queryStringIdx - 1) == '/') {
            return url;
        }
        return url.substring(0, queryStringIdx) + "/" + url.substring(queryStringIdx);
    }

    public static Options parseOptionString(String optionString) {
        String[] urlTokens = optionString.split("\\?", 2);
        String[] actionTokens = urlTokens[0].split("#", 2);
        Options options = new Options();
        if (actionTokens.length == 1) {
            options.$("action", actionTokens[0]);
            options.$("controller", ControllerUtil.currentController());
        } else {
            options.$("controller", actionTokens[0]).$("action", actionTokens[1]);
        }
        if (urlTokens.length == 2 && !ARStringUtil.isEmpty(urlTokens[1])) {
            String[] paramToken;
            for (String keyValuePair : paramToken = urlTokens[1].split("&")) {
                String[] pair = keyValuePair.split("=", 2);
                if (pair.length == 1) {
                    options.$(pair[0], null);
                    continue;
                }
                if (pair.length != 2) continue;
                Object value = options.get(pair[0]);
                if (value == null) {
                    options.$(pair[0], pair[1]);
                    continue;
                }
                if (value instanceof ArrayList) {
                    ((ArrayList)value).add(pair[1]);
                    continue;
                }
                ArrayList<String> values = new ArrayList<String>();
                values.add(value.toString());
                values.add(pair[1]);
                options.$(pair[0], values);
            }
        }
        return options;
    }
}

