/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router.recognizer;

import java.util.ArrayList;
import java.util.List;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.Recognizer;
import net.unit8.http.router.RegexpUtil;
import net.unit8.http.router.Route;
import net.unit8.http.router.RouteBuilder;
import net.unit8.http.router.RoutingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizedRecognizer
extends Recognizer {
    private SegmentNode tree;
    private List<Route> routes;

    public String[] toPlainSegments(String str) {
        str = str.replaceAll("^/+", "").replaceAll("/+$", "");
        return str.split("\\.[^/]+\\/+|[" + RegexpUtil.escape(ARStringUtil.join(RouteBuilder.SEPARATORS)) + "]+|\\.[^/]+\\Z");
    }

    @Override
    public void setRoutes(List<Route> routes) {
        this.routes = routes;
        this.optimize();
    }

    @Override
    public boolean isOptimized() {
        return this.tree != null;
    }

    @Override
    public void optimize() {
        this.tree = new SegmentNode(0);
        int i = -1;
        for (Route route : this.routes) {
            String[] segments;
            ++i;
            SegmentNode node = this.tree;
            for (String seg : segments = this.toPlainSegments(ARStringUtil.join(route.getSegments(), ""))) {
                if (!ARStringUtil.isEmpty(seg) && seg.charAt(0) == ':') {
                    seg = ":dynamic";
                }
                if (node.isEmpty() || !ARStringUtil.equals(node.lastChild().getLabel(), seg)) {
                    node.add(new SegmentNode(seg, i));
                }
                node = node.lastChild();
            }
        }
    }

    private int calcIndex(String[] segments, SegmentNode node, int level) {
        if (node.size() <= 1 || segments.length == level) {
            return node.getIndex();
        }
        String seg = segments[level];
        for (SegmentNode item : node.getChildNodes()) {
            if (!ARStringUtil.equals(item.getLabel(), ":dynamic") && !ARStringUtil.equals(item.getLabel(), seg)) continue;
            return this.calcIndex(segments, item, level + 1);
        }
        return node.getIndex();
    }

    @Override
    public Options recognize(String path, String method) {
        String[] segments = this.toPlainSegments(path);
        for (int index = this.calcIndex(segments, this.tree, 0); index < this.routes.size(); ++index) {
            Options result = this.routes.get(index).recognize(path, method);
            if (result == null) continue;
            return result;
        }
        throw new RoutingException("No route matches " + path);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SegmentNode {
        private int index;
        private String label;
        private List<SegmentNode> childNodes;

        public SegmentNode(int index) {
            this(null, index);
        }

        public SegmentNode(String label, int index) {
            this.index = index;
            this.label = label;
            this.childNodes = new ArrayList<SegmentNode>();
        }

        public void add(SegmentNode child) {
            this.childNodes.add(child);
        }

        public boolean isEmpty() {
            return this.childNodes.isEmpty();
        }

        public SegmentNode lastChild() {
            if (this.isEmpty()) {
                return null;
            }
            return this.childNodes.get(this.childNodes.size() - 1);
        }

        public String getLabel() {
            return this.label;
        }

        public int getIndex() {
            return this.index;
        }

        public List<SegmentNode> getChildNodes() {
            return this.childNodes;
        }

        public int size() {
            return this.childNodes.size();
        }
    }
}

