/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router.segment;

import java.util.ArrayList;
import java.util.regex.Matcher;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.ControllerUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.RegexpUtil;
import net.unit8.http.router.Routes;
import net.unit8.http.router.segment.DynamicSegment;

public class ControllerSegment
extends DynamicSegment {
    public ControllerSegment(String value, Options options) {
        super(value, options);
    }

    public ControllerSegment(String key) {
        super(key);
    }

    public String regexpChunk() {
        ArrayList<String> possibleNames = new ArrayList<String>();
        for (String name : Routes.possibleControllers()) {
            possibleNames.add(RegexpUtil.escape(name));
        }
        return "(?i-:(" + ARStringUtil.join(possibleNames, "|") + "))";
    }

    public void matchExtraction(Options params, Matcher match, int nextCapture) {
        String key = this.getKey();
        String token = match.group(nextCapture);
        if (this.getDefault() != null) {
            params.put(key, !ARStringUtil.isEmpty(token) ? ControllerUtil.fromPathToClassName(token) : this.getDefault());
        } else if (!ARStringUtil.isEmpty(token)) {
            params.put(key, ControllerUtil.fromPathToClassName(token));
        }
    }

    public String interpolationChunk(Options hash) {
        String value = hash.getString(this.getKey());
        String path = value.replace(".", "/");
        if (path != null) {
            path = path.lastIndexOf(47) >= 0 ? ARStringUtil.substringBeforeLast(path, "/") + "/" + ARStringUtil.decapitalize(ARStringUtil.substringAfterLast(path, "/")) : ARStringUtil.decapitalize(path);
        }
        return path;
    }
}

