/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router.segment;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.RegexpUtil;
import net.unit8.http.router.RouteBuilder;
import net.unit8.http.router.Segment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicSegment
extends Segment {
    private String key;
    private String defaultValue;
    private Pattern regexp;
    private boolean wrapParentheses = false;

    public DynamicSegment(String key) {
        this(key, new Options());
    }

    public DynamicSegment(String key, Options options) {
        this.key = key;
        if (options.containsKey("default")) {
            this.defaultValue = options.getString("default");
        }
        if (options.containsKey("regexp")) {
            this.regexp = Pattern.compile(options.getString("regexp"));
        }
        if (options.containsKey("wrapParentheses")) {
            this.wrapParentheses = options.getBoolean("wrapParentheses");
        }
    }

    public String toString() {
        return this.wrapParentheses ? "(:" + this.key + ")" : ":" + this.key;
    }

    @Override
    public boolean hasKey() {
        return true;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String regexpChunk() {
        return this.regexp != null ? "(" + this.regexp.pattern() + ")" : this.defaultRegexpChunk();
    }

    public String defaultRegexpChunk() {
        return "([^" + RegexpUtil.escape(ARStringUtil.join(RouteBuilder.SEPARATORS)) + "]+)";
    }

    @Override
    public boolean hasDefault() {
        return true;
    }

    @Override
    public String getDefault() {
        return this.defaultValue;
    }

    @Override
    public void setDefault(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public void setRegexp(Pattern regexp) {
        this.regexp = regexp;
    }

    @Override
    public void matchExtraction(Options params, Matcher match, int nextCapture) {
        String value;
        String m = match.group(nextCapture);
        if (m != null) {
            try {
                value = URLDecoder.decode(m, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                value = m;
            }
        } else {
            value = this.defaultValue;
        }
        params.put(this.key, value);
    }

    @Override
    public String buildPattern(String pattern) {
        pattern = this.regexpChunk() + pattern;
        return this.isOptional() ? RegexpUtil.optionalize(pattern) : pattern;
    }

    @Override
    public String interpolationChunk(Options hash) {
        String value = hash.getString(this.getKey());
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return value;
        }
    }

    @Override
    public String stringStructure(List<Segment> list, Options hash) {
        if (this.isOptional()) {
            if (ARStringUtil.equals(hash.getString(this.getKey()), this.getDefault())) {
                return this.continueStringStructure(list, hash);
            }
            return this.interpolationStatement(list, hash);
        }
        return this.interpolationStatement(list, hash);
    }
}

