/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.http.router.segment;

import net.unit8.http.router.ARStringUtil;
import net.unit8.http.router.Options;
import net.unit8.http.router.RegexpUtil;
import net.unit8.http.router.Segment;

public class StaticSegment
extends Segment {
    private boolean raw;

    public StaticSegment(String value) {
        this(value, new Options());
    }

    public StaticSegment(String value, Options options) {
        super(value);
        if (options.containsKey("raw")) {
            this.raw = options.getBoolean("raw");
        }
        if (options.containsKey("optional")) {
            this.setOptional(options.getBoolean("optional"));
        }
    }

    public String interpolationChunk(Options hash) {
        return this.raw ? this.getValue() : super.interpolationChunk(hash);
    }

    public String regexpChunk() {
        String chunk = RegexpUtil.escape(this.getValue());
        return this.isOptional() ? RegexpUtil.optionalize(chunk) : chunk;
    }

    public int numberOfCaptures() {
        return 0;
    }

    public String buildPattern(String pattern) {
        String escaped = RegexpUtil.escape(this.getValue());
        if (this.isOptional() && !ARStringUtil.isEmpty(pattern)) {
            return "(?:" + RegexpUtil.optionalize(escaped) + "\\Z|" + escaped + RegexpUtil.unoptionalize(pattern) + ")";
        }
        if (this.isOptional()) {
            return RegexpUtil.optionalize(escaped);
        }
        return escaped + pattern;
    }

    public String toString() {
        return this.getValue();
    }
}

