/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.logback;

import ch.qos.logback.classic.net.LoggingEventPreSerializationTransformer;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.spi.PreSerializationTransformer;
import ch.qos.logback.core.util.CloseUtil;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class WebSocketAppender
extends AppenderBase<ILoggingEvent> {
    private static final PreSerializationTransformer<ILoggingEvent> pst = new LoggingEventPreSerializationTransformer();
    private URI serverUri;
    private Session session;

    private void started() {
        super.start();
    }

    public void start() {
        if (this.isStarted()) {
            return;
        }
        WebSocketContainer container = ContainerProvider.getWebSocketContainer();
        try {
            this.session = container.connectToServer(new Endpoint(){

                public void onOpen(Session session, EndpointConfig endpointConfig) {
                    WebSocketAppender.this.started();
                }

                public void onClose(Session session, CloseReason closeReason) {
                }
            }, ClientEndpointConfig.Builder.create().build(), this.serverUri);
        }
        catch (Exception ex) {
            this.addError("Connect server error", ex);
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly((Closeable)this.session);
        super.stop();
    }

    protected void append(ILoggingEvent event) {
        if (event == null || !this.isStarted()) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        RemoteEndpoint.Async remote = this.session.getAsyncRemote();
        Serializable serEvent = pst.transform((Object)event);
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(serEvent);
            oos.flush();
            remote.sendBinary(ByteBuffer.wrap(baos.toByteArray()));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setServerUri(String uri) {
        this.serverUri = URI.create(uri);
    }
}

