/*
 * Decompiled with CFR 0.152.
 */
package net.unit8.logback.server;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.CloseUtil;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/")
public class WebSocketReceiver
extends Endpoint {
    @OnOpen
    public void onOpen(Session session, EndpointConfig config) {
        ILoggerFactory factory = LoggerFactory.getILoggerFactory();
        if (!(factory instanceof LoggerContext)) {
            CloseUtil.closeQuietly((Closeable)session);
            throw new IllegalStateException("LoggerFactory isn't LoggerContext.");
        }
        final LoggerContext context = (LoggerContext)factory;
        session.addMessageHandler((MessageHandler)new MessageHandler.Whole<byte[]>(){

            public void onMessage(byte[] message) {
                try {
                    ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(message));
                    ILoggingEvent event = (ILoggingEvent)ois.readObject();
                    Logger remoteLogger = context.getLogger(event.getLoggerName());
                    if (remoteLogger.isEnabledFor(event.getLevel())) {
                        remoteLogger.callAppenders(event);
                    }
                }
                catch (IOException ex) {
                    WebSocketReceiver.this.addStatus(context, (Status)new ErrorStatus("IO Error", (Object)ex));
                }
                catch (ClassNotFoundException ex) {
                    WebSocketReceiver.this.addStatus(context, (Status)new ErrorStatus("unknown event class", (Object)ex));
                }
            }
        });
    }

    public void addStatus(LoggerContext context, Status status) {
        StatusManager sm;
        if (context != null && (sm = context.getStatusManager()) != null) {
            sm.add(status);
        }
    }
}

