/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.bean;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.cglib.beans.BeanGenerator;
import net.sf.cglib.beans.BeanMap;

public class ClassUtils {
    public static Object dynamicClass(Object object, HashMap<String, Object> addMap, HashMap<String, Object> addValMap) throws Exception {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, Object> typeMap = new HashMap<String, Object>();
        Class<?> type = object.getClass();
        BeanInfo beanInfo = Introspector.getBeanInfo(type);
        for (PropertyDescriptor descriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
            String propertyName = descriptor.getName();
            if (propertyName.equals("class")) continue;
            Method readMethod = descriptor.getReadMethod();
            Object result = readMethod.invoke(object, new Object[0]);
            returnMap.put(propertyName, result);
            typeMap.put(propertyName, descriptor.getPropertyType());
        }
        returnMap.putAll(addValMap);
        typeMap.putAll(addMap);
        DynamicBean bean = new DynamicBean(typeMap);
        Set keys = typeMap.keySet();
        for (String key : keys) {
            bean.setValue(key, returnMap.get(key));
        }
        return bean.getObject();
    }

    static class DynamicBean {
        private Object object = null;
        private BeanMap beanMap = null;

        public DynamicBean() {
        }

        public DynamicBean(Map propertyMap) {
            this.object = this.generateBean(propertyMap);
            this.beanMap = BeanMap.create((Object)this.object);
        }

        private Object generateBean(Map propertyMap) {
            BeanGenerator generator = new BeanGenerator();
            Set keySet = propertyMap.keySet();
            for (String key : keySet) {
                generator.addProperty(key, (Class)propertyMap.get(key));
            }
            return generator.create();
        }

        public void setValue(Object property, Object value) {
            this.beanMap.put(property, value);
        }

        public Object getValue(String property) {
            return this.beanMap.get((Object)property);
        }

        public Object getObject() {
            return this.object;
        }
    }
}

