/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.unmz.java.util.json.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    public static String doGet(String url) throws Exception {
        return HttpUtils.doGet(url, null, null, null);
    }

    public static HttpResponse doGetResponse(String url) throws Exception {
        return HttpUtils.doGetResponse(url, null, null, null);
    }

    public static String doGet(String host, String path, Map<String, String> headers, Map<String, String> queries) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doGetResponse(host, path, headers, queries).getEntity(), (String)"utf-8");
    }

    public static HttpResponse doGetResponse(String host, String path, Map<String, String> headers, Map<String, String> queries) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        if (queries == null) {
            queries = new HashMap<String, String>();
        }
        HttpGet request = new HttpGet(HttpUtils.buildUrl(host, path, queries));
        if (headers == null) {
            headers = new HashMap<String, String>();
            HttpUtils.setHttpHeader((HttpRequest)request);
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static String doPost(String host, String path, Map<String, String> body) throws Exception {
        return HttpUtils.doPost(host, path, null, null, body);
    }

    public static String doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, Map<String, String> bodies) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doPostResponse(host, path, headers, queries, JsonUtils.toJSON(bodies)).getEntity(), (String)"utf-8");
    }

    public static String doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doPostResponse(host, path, headers, queries, body).getEntity(), (String)"utf-8");
    }

    public static HttpResponse doPostResponse(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        if (queries == null) {
            queries = new HashMap<String, String>();
        }
        HttpPost request = new HttpPost(HttpUtils.buildUrl(host, path, queries));
        if (headers == null) {
            headers = new HashMap<String, String>();
            HttpUtils.setHttpHeader((HttpRequest)request);
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static String doPost(String host, String path, Map<String, String> headers, Map<String, String> queries, byte[] body) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doPostResponse(host, path, headers, queries, body).getEntity(), (String)"utf-8");
    }

    public static HttpResponse doPostResponse(String host, String path, Map<String, String> headers, Map<String, String> queries, byte[] body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        if (queries == null) {
            queries = new HashMap<String, String>();
        }
        HttpPost request = new HttpPost(HttpUtils.buildUrl(host, path, queries));
        if (headers == null) {
            headers = new HashMap<String, String>();
            HttpUtils.setHttpHeader((HttpRequest)request);
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (body != null) {
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static String doPut(String host, String path, Map<String, String> headers, Map<String, String> queries) throws Exception {
        return HttpUtils.doPut(host, path, headers, queries, "");
    }

    public static HttpResponse doPutResponse(String host, String path, Map<String, String> headers, Map<String, String> queries) throws Exception {
        return HttpUtils.doPutResponse(host, path, headers, queries, "");
    }

    public static String doPut(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doPutResponse(host, path, headers, queries, body).getEntity(), (String)"utf-8");
    }

    public static HttpResponse doPutResponse(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        if (queries == null) {
            queries = new HashMap<String, String>();
        }
        HttpPut request = new HttpPut(HttpUtils.buildUrl(host, path, queries));
        if (headers == null) {
            headers = new HashMap<String, String>();
            HttpUtils.setHttpHeader((HttpRequest)request);
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static String doPut(String host, String path, Map<String, String> headers, Map<String, String> queries, byte[] body) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doPutResponse(host, path, headers, queries, body).getEntity(), (String)"utf-8");
    }

    public static HttpResponse doPutResponse(String host, String path, Map<String, String> headers, Map<String, String> queries, byte[] body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        if (queries == null) {
            queries = new HashMap<String, String>();
        }
        HttpPut request = new HttpPut(HttpUtils.buildUrl(host, path, queries));
        if (headers == null) {
            headers = new HashMap<String, String>();
            HttpUtils.setHttpHeader((HttpRequest)request);
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (body != null) {
            request.setEntity((HttpEntity)new ByteArrayEntity(body));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    public static String doDelete(String host, String path, Map<String, String> headers, Map<String, String> queries) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doDeleteResponse(host, path, headers, queries).getEntity(), (String)"utf-8");
    }

    public static String doDelete(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doDeleteResponse(host, path, headers, queries, body).getEntity(), (String)"utf-8");
    }

    public static String doDelete(String host, String path, Map<String, String> headers, Map<String, String> queries, Map<String, String> body) throws Exception {
        return EntityUtils.toString((HttpEntity)HttpUtils.doDeleteResponse(host, path, headers, queries, JsonUtils.toJSON(body)).getEntity(), (String)"utf-8");
    }

    public static HttpResponse doDeleteResponse(String host, String path, Map<String, String> headers, Map<String, String> queries) throws Exception {
        return HttpUtils.doDeleteResponse(host, path, headers, queries, "");
    }

    public static HttpResponse doDeleteResponse(String host, String path, Map<String, String> headers, Map<String, String> queries, String body) throws Exception {
        HttpClient httpClient = HttpUtils.wrapClient(host);
        if (queries == null) {
            queries = new HashMap<String, String>();
        }
        HttpDeleteWithBody request = new HttpDeleteWithBody(HttpUtils.buildUrl(host, path, queries));
        if (headers == null) {
            headers = new HashMap<String, String>();
            HttpUtils.setHttpHeader((HttpRequest)request);
        }
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.addHeader(e.getKey(), e.getValue());
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            request.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
        }
        return httpClient.execute((HttpUriRequest)request);
    }

    private static String buildUrl(String host, String path, Map<String, String> queries) throws UnsupportedEncodingException {
        StringBuilder sbUrl = new StringBuilder();
        sbUrl.append(host);
        if (!StringUtils.isBlank((CharSequence)path)) {
            sbUrl.append(path);
        }
        if (null != queries) {
            StringBuilder sbQuery = new StringBuilder();
            for (Map.Entry<String, String> query : queries.entrySet()) {
                if (0 < sbQuery.length()) {
                    sbQuery.append("&");
                }
                if (StringUtils.isBlank((CharSequence)query.getKey()) && !StringUtils.isBlank((CharSequence)query.getValue())) {
                    sbQuery.append(query.getValue());
                }
                if (StringUtils.isBlank((CharSequence)query.getKey())) continue;
                sbQuery.append(query.getKey());
                if (StringUtils.isBlank((CharSequence)query.getValue())) continue;
                sbQuery.append("=");
                sbQuery.append(URLEncoder.encode(query.getValue(), "utf-8"));
            }
            if (0 < sbQuery.length()) {
                sbUrl.append("?").append((CharSequence)sbQuery);
            }
        }
        return sbUrl.toString();
    }

    private static HttpClient wrapClient(String host) {
        DefaultHttpClient httpClient = new DefaultHttpClient();
        if (host.startsWith("https://")) {
            HttpUtils.sslClient((HttpClient)httpClient);
        }
        return httpClient;
    }

    private static void sslClient(HttpClient httpClient) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            X509TrustManager tm = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] xcs, String str) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] xcs, String str) {
                }
            };
            ctx.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory ssf = new SSLSocketFactory(ctx);
            ssf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            ClientConnectionManager ccm = httpClient.getConnectionManager();
            SchemeRegistry registry = ccm.getSchemeRegistry();
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)ssf));
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void setHttpHeader(HttpRequest request) {
        request.setHeader((Header)new BasicHeader("Content-Type", "application/json;charset=utf-8"));
    }

    static class HttpDeleteWithBody
    extends HttpEntityEnclosingRequestBase {
        static final String METHOD_NAME = "DELETE";

        public String getMethod() {
            return METHOD_NAME;
        }

        HttpDeleteWithBody(String uri) {
            this.setURI(URI.create(uri));
        }

        public HttpDeleteWithBody(URI uri) {
            this.setURI(uri);
        }

        public HttpDeleteWithBody() {
        }
    }
}

