/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.images;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class ImageUtils {
    public static void reduceImg(String imageSrc, String imgDist) {
        try {
            File srcFile = new File(imageSrc);
            File dist = new File(imgDist);
            ImageUtils.reduceImage(srcFile, dist);
        }
        catch (Exception ef) {
            ef.printStackTrace();
        }
    }

    public static void reduceImg(File srcFile, File imgDist) {
        try {
            ImageUtils.reduceImage(srcFile, imgDist);
        }
        catch (Exception ef) {
            ef.printStackTrace();
        }
    }

    private static void reduceImage(File srcFile, File imgDist) throws IOException {
        if (!srcFile.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        int[] results = ImageUtils.getImgWidthHeight(srcFile);
        int widthDist = results[0];
        int heightDist = results[1];
        BufferedImage src = ImageIO.read(srcFile);
        BufferedImage tag = new BufferedImage(widthDist, heightDist, 1);
        tag.getGraphics().drawImage(src.getScaledInstance(widthDist, heightDist, 4), 0, 0, null);
        FileOutputStream out = new FileOutputStream(imgDist);
        JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
        encoder.encode(tag);
        out.close();
    }

    public static int[] getImgWidthHeight(File file) {
        int[] result = new int[]{0, 0};
        try {
            FileInputStream is = new FileInputStream(file);
            BufferedImage src = ImageIO.read(is);
            result[0] = src.getWidth(null);
            result[1] = src.getHeight(null);
            ((InputStream)is).close();
        }
        catch (Exception ef) {
            ef.printStackTrace();
        }
        return result;
    }
}

