/*
 * Decompiled with CFR 0.152.
 */
package net.unmz.java.util.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    private static final SerializeConfig config = new SerializeConfig();
    private static final SerializerFeature[] features = new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteNullStringAsEmpty};

    public static String toJSON(Object obj) {
        return JSON.toJSONString((Object)obj, (SerializeConfig)config, (SerializerFeature[])features);
    }

    @Deprecated
    public static String toJSONNoFeatures(Object object) {
        return JSON.toJSONString((Object)object, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[0]);
    }

    public static Object toBean(String text) {
        return JSON.parse((String)text);
    }

    public static <T> T toBean(String text, Class<T> clazz) {
        return (T)JSON.parseObject((String)text, clazz);
    }

    public static Object[] toBeanArray(String text) {
        return JsonUtils.toBeanArray(text, null);
    }

    public static <T> Object[] toBeanArray(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz).toArray();
    }

    public static <T> List<T> toBeanList(String text, Class<T> clazz) {
        return JSON.parseArray((String)text, clazz);
    }

    public static Map JSONToMap(String text) {
        return JSONObject.parseObject((String)text);
    }

    public static String MapToJSON(Map map) {
        return JSONObject.toJSONString((Object)map);
    }
}

