/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model;

import net.vatov.ampl.model.Expression;

public class ConstraintDeclaration {
    private String name;
    private RelopType relop;
    private Expression aExpr;
    private Expression bExpr;

    public ConstraintDeclaration(String name, String relop, Expression aExpr, Expression bExpr) {
        this(name, RelopType.parseRelop(relop), aExpr, bExpr);
    }

    public ConstraintDeclaration(String name, RelopType relop, Expression aExpr, Expression bExpr) {
        this.name = name;
        this.relop = relop;
        this.aExpr = aExpr;
        this.bExpr = bExpr;
    }

    public String getName() {
        return this.name;
    }

    public RelopType getRelop() {
        return this.relop;
    }

    public Expression getaExpr() {
        return this.aExpr;
    }

    public Expression getbExpr() {
        return this.bExpr;
    }

    public static enum RelopType {
        GE,
        EQ,
        LE;


        public static RelopType parseRelop(String relop) {
            if (">=".equals(relop)) {
                return GE;
            }
            if ("=".equals(relop)) {
                return EQ;
            }
            if ("<=".equals(relop)) {
                return LE;
            }
            throw new RuntimeException("Not implemented");
        }
    }
}

