/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model;

import java.util.List;
import net.vatov.ampl.model.ModelException;
import net.vatov.ampl.model.NodeValue;
import net.vatov.ampl.model.SymbolDeclaration;

public class Expression
implements Cloneable {
    private ExpressionType type;
    private Object value;

    public ExpressionType getType() {
        return this.type;
    }

    public void setValue(Double value) {
        this.value = value;
        this.type = ExpressionType.DOUBLE;
    }

    public void setSymRef(SymbolDeclaration symref) {
        this.value = symref;
        this.type = ExpressionType.SYMREF;
    }

    public void setTreeValue(NodeValue.OperationType operation, Expression ... operands) {
        this.value = new NodeValue(operation, operands);
        this.type = ExpressionType.TREE;
    }

    public void setTreeValue(NodeValue.BuiltinFunction function, List<Expression> params) {
        Expression[] arr = null;
        if (params != null) {
            arr = params.toArray(new Expression[params.size()]);
        }
        this.value = new NodeValue(NodeValue.OperationType.BUILTIN_FUNCTION, arr);
        ((NodeValue)this.value).setBuiltinFunction(function);
        this.type = ExpressionType.TREE;
    }

    public Double getValue() {
        if (this.type != ExpressionType.DOUBLE) {
            throw new ModelException("Not a simple value");
        }
        return (Double)this.value;
    }

    public NodeValue getTreeValue() {
        if (this.type != ExpressionType.TREE) {
            throw new ModelException("Not a tree");
        }
        return (NodeValue)this.value;
    }

    public SymbolDeclaration getSymRef() {
        if (this.type != ExpressionType.SYMREF) {
            throw new ModelException("Not a symbol reference");
        }
        return (SymbolDeclaration)this.value;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        return ret.append("[").append(this.type.toString()).append(":").append(this.value.toString()).append("]").toString();
    }

    public Object clone() {
        Expression e = new Expression();
        e.type = this.type;
        switch (this.type) {
            case DOUBLE: {
                e.value = this.getValue();
                break;
            }
            case TREE: {
                e.value = this.getTreeValue().clone();
                break;
            }
            case SYMREF: {
                e.value = this.getSymRef().clone();
                break;
            }
            default: {
                throw new ModelException("type not supported " + (Object)((Object)this.type));
            }
        }
        return e;
    }

    public static enum ExpressionType {
        DOUBLE,
        TREE,
        SYMREF;

    }
}

