/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model;

import net.vatov.ampl.model.Expression;
import net.vatov.ampl.model.ModelException;

public class NodeValue
implements Cloneable {
    private OperationType operation;
    private Expression[] operands;
    private BuiltinFunction fType;

    public BuiltinFunction getBuiltinFunction() {
        this.checkBuiltinFunction();
        return this.fType;
    }

    void setBuiltinFunction(BuiltinFunction fType) {
        this.checkBuiltinFunction();
        this.fType = fType;
    }

    private void checkBuiltinFunction() {
        if (!this.operation.equals((Object)OperationType.BUILTIN_FUNCTION)) {
            throw new ModelException("Only " + OperationType.BUILTIN_FUNCTION.name() + " operations can use builtinFunction");
        }
    }

    public NodeValue(OperationType operation, Expression ... operands) {
        this.operation = operation;
        this.operands = operands;
    }

    public OperationType getOperation() {
        return this.operation;
    }

    public Expression[] getOperands() {
        return this.operands;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("'").append((Object)this.operation).append("' ");
        if (OperationType.BUILTIN_FUNCTION.equals((Object)this.operation)) {
            ret.append("'").append((Object)this.fType).append("' ");
        }
        if (null == this.operands) {
            return ret.toString();
        }
        for (Expression e : this.operands) {
            ret.append(e.toString());
        }
        return ret.toString();
    }

    public Object clone() {
        Expression[] o = new Expression[this.operands.length];
        for (int i = 0; i < this.operands.length; ++i) {
            o[i] = this.operands[i];
        }
        return new NodeValue(this.operation, o);
    }

    public static enum OperationType {
        PLUS,
        MINUS,
        MULT,
        DIV_SLASH,
        MOD,
        DIV,
        POW,
        BUILTIN_FUNCTION,
        UNARY_MINUS,
        UNARY_PLUS;

    }

    public static enum BuiltinFunction {
        ABS,
        ACOS,
        ACOSH,
        ASIN,
        ASINH,
        ATAN,
        ATAN2,
        ATANH,
        CEIL,
        CTIME,
        COS,
        EXP,
        FLOOR,
        LOG,
        LOG10,
        MAX,
        MIN,
        PRECISION,
        ROUND,
        SIN,
        SINH,
        SQRT,
        TAN,
        TANH,
        TIME,
        TRUNC;

    }
}

