/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model;

import java.util.ArrayList;
import java.util.List;
import net.vatov.ampl.model.Expression;
import net.vatov.ampl.model.ModelException;

public class ObjectiveDeclaration {
    private Goal goal;
    private String name;
    private Expression expression;

    public ObjectiveDeclaration(Goal goal, String name, Expression expression) {
        this.goal = goal;
        this.name = name;
        this.expression = expression;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append((Object)this.goal).append(" ").append(this.name).append(": ").append(this.expression.toString()).append("\n");
        return ret.toString();
    }

    public static enum Goal {
        MINIMIZE("minimize", "min"),
        MAXIMIZE("maximize", "max");

        private List<String> variants = new ArrayList<String>();

        private Goal(String ... variants) {
            for (String v : variants) {
                this.variants.add(v);
            }
        }

        public boolean isVariant(String value) {
            for (String v : this.variants) {
                if (!v.equalsIgnoreCase(value)) continue;
                return true;
            }
            return false;
        }

        public static Goal fromString(String value) {
            for (Goal g : Goal.values()) {
                if (!g.isVariant(value)) continue;
                return g;
            }
            throw new ModelException(value);
        }
    }
}

