/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model;

import java.util.ArrayList;
import java.util.List;
import net.vatov.ampl.model.ConstraintDeclaration;
import net.vatov.ampl.model.Expression;
import net.vatov.ampl.model.ModelException;
import net.vatov.ampl.model.ObjectiveDeclaration;
import net.vatov.ampl.model.SymbolDeclaration;

public class OptimModel {
    private ArrayList<SymbolDeclaration> symbolDeclarations = new ArrayList();
    private ArrayList<ObjectiveDeclaration> objectives = new ArrayList();
    private ArrayList<ConstraintDeclaration> constraints = new ArrayList();

    public ConstraintDeclaration addConstraint(String name, String relop, Expression aExpr, Expression bExpr) {
        ConstraintDeclaration c = new ConstraintDeclaration(name, relop, aExpr, bExpr);
        this.constraints.add(c);
        return c;
    }

    public ObjectiveDeclaration addObjective(String goal, String name, Expression expression) {
        ObjectiveDeclaration.Goal g = ObjectiveDeclaration.Goal.fromString(goal);
        ObjectiveDeclaration o = new ObjectiveDeclaration(g, name, expression);
        this.objectives.add(o);
        return o;
    }

    public List<ConstraintDeclaration> getConstraints() {
        return this.constraints;
    }

    public List<ObjectiveDeclaration> getObjectives() {
        return this.objectives;
    }

    public ArrayList<SymbolDeclaration> getSymbolDeclarations() {
        return this.symbolDeclarations;
    }

    public boolean paramIsDefined(String name) {
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (!sd.getName().equals(name) || SymbolDeclaration.SymbolType.PARAM != sd.getType()) continue;
            return true;
        }
        return false;
    }

    public boolean symbolIsDefined(String name) {
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (!sd.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Double getParamValue(String name) {
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (!sd.getName().equals(name) || SymbolDeclaration.SymbolType.PARAM != sd.getType()) continue;
            Expression e = (Expression)sd.getAttributes().get((Object)SymbolDeclaration.DeclarationAttributeEnum.VALUE);
            if (e.getType() != Expression.ExpressionType.DOUBLE) {
                throw new ModelException("param '" + name + "' is not constant");
            }
            return e.getValue();
        }
        throw new ModelException("param " + name + " not defined");
    }

    public boolean varIsDefined(String name) {
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (!sd.getName().equals(name) || SymbolDeclaration.SymbolType.VAR != sd.getType()) continue;
            return true;
        }
        return false;
    }

    public SymbolDeclaration getVarRef(String name) {
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (!sd.getName().equals(name) || SymbolDeclaration.SymbolType.VAR != sd.getType()) continue;
            return sd;
        }
        throw new ModelException("var " + name + " not defined");
    }

    public SymbolDeclaration getSetRef(String name) {
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (!sd.getName().equals(name) || SymbolDeclaration.SymbolType.SET != sd.getType()) continue;
            return sd;
        }
        throw new ModelException("set " + name + " not defined");
    }

    public SymbolDeclaration getSymbolRef(String name) {
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (!sd.getName().equals(name)) continue;
            return sd;
        }
        throw new ModelException("symbol " + name + " not defined");
    }

    public SymbolDeclaration getParamRef(String name) {
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (!sd.getName().equals(name) || SymbolDeclaration.SymbolType.PARAM != sd.getType()) continue;
            return sd;
        }
        throw new ModelException("param " + name + " not defined");
    }

    public List<SymbolDeclaration> getVarRefs() {
        ArrayList<SymbolDeclaration> ret = new ArrayList<SymbolDeclaration>();
        for (SymbolDeclaration sd : this.symbolDeclarations) {
            if (SymbolDeclaration.SymbolType.VAR != sd.getType()) continue;
            ret.add(sd);
        }
        return ret;
    }

    public void addSymbolDeclaration(SymbolDeclaration decl) {
        if (this.symbolDeclarations.contains(decl)) {
            throw new ModelException(decl.getType().toString().toLowerCase() + " " + decl.getName() + " already defined");
        }
        this.symbolDeclarations.add(decl);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (null != this.symbolDeclarations && !this.symbolDeclarations.isEmpty()) {
            ret.append("[Symbols]\n");
            for (SymbolDeclaration sd : this.symbolDeclarations) {
                ret.append(sd.toString()).append("\n");
            }
        }
        if (null != this.objectives && !this.objectives.isEmpty()) {
            ret.append("[Objectives]\n");
            for (ObjectiveDeclaration o : this.objectives) {
                ret.append(o.toString()).append("\n");
            }
        }
        return ret.toString();
    }
}

