/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model;

import net.vatov.ampl.model.SetExpression;

public class SetNodeValue {
    private SetOperationType operation;
    private SetExpression[] operands;

    public SetNodeValue(SetOperationType operation, SetExpression ... operands) {
        this.operation = operation;
        this.operands = operands;
    }

    public SetOperationType getOperation() {
        return this.operation;
    }

    public SetExpression[] getOperands() {
        return this.operands;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("'").append((Object)this.operation).append("' ");
        if (null == this.operands) {
            return ret.toString();
        }
        for (SetExpression e : this.operands) {
            if (e.getType().equals((Object)SetExpression.SetExpressionType.VARREF)) {
                ret.append(e.getSymbolDeclaration().getName());
            } else {
                ret.append(e.toString());
            }
            ret.append(", ");
        }
        ret.delete(ret.length() - 2, ret.length());
        return ret.toString();
    }

    public Object clone() {
        SetExpression[] o = new SetExpression[this.operands.length];
        for (int i = 0; i < this.operands.length; ++i) {
            o[i] = this.operands[i];
        }
        return new SetNodeValue(this.operation, o);
    }

    public static enum SetOperationType {
        UNION,
        INTER,
        DIFF,
        SYMDIFF,
        CROSS;


        public static SetOperationType parse(String value) {
            return SetOperationType.valueOf(value.toUpperCase());
        }
    }
}

