/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model;

import java.util.HashMap;
import java.util.Map;
import net.vatov.ampl.model.Expression;
import net.vatov.ampl.model.ModelException;

public class SymbolDeclaration
implements Cloneable {
    private String name;
    private Map<DeclarationAttributeEnum, Object> attributes;
    private SymbolType type;

    private SymbolDeclaration(String name, SymbolType type) {
        if (null == name || null == type) {
            throw new ModelException("both name and type are mandatory");
        }
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public Expression getValue() {
        if (null == this.attributes) {
            return null;
        }
        return (Expression)this.attributes.get((Object)DeclarationAttributeEnum.VALUE);
    }

    public Expression getLowerBound() {
        if (null == this.attributes) {
            return null;
        }
        return (Expression)this.attributes.get((Object)DeclarationAttributeEnum.LOWER_BOUND);
    }

    public Expression getUpperBound() {
        if (null == this.attributes) {
            return null;
        }
        return (Expression)this.attributes.get((Object)DeclarationAttributeEnum.UPPER_BOUND);
    }

    public Boolean isInteger() {
        if (null == this.attributes) {
            return null;
        }
        return (Boolean)this.attributes.get((Object)DeclarationAttributeEnum.INTEGER);
    }

    public Boolean isBinary() {
        if (null == this.attributes) {
            return null;
        }
        return (Boolean)this.attributes.get((Object)DeclarationAttributeEnum.BINARY);
    }

    public void setBindValue(Double value) {
        if (null == this.attributes) {
            this.attributes = new HashMap<DeclarationAttributeEnum, Object>();
        }
        this.attributes.put(DeclarationAttributeEnum.BINDED_VALUE, value);
    }

    public Double getBindValue() {
        if (null == this.attributes) {
            return null;
        }
        return (Double)this.attributes.get((Object)DeclarationAttributeEnum.BINDED_VALUE);
    }

    public Map<DeclarationAttributeEnum, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<DeclarationAttributeEnum, Object> attributes) {
        this.attributes = attributes;
    }

    public SymbolType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.name);
        ret.append(": ").append(this.attributes);
        return ret.toString();
    }

    public static SymbolDeclaration createParamDeclaration(String name) {
        return new SymbolDeclaration(name, SymbolType.PARAM);
    }

    public static SymbolDeclaration createVarDeclaration(String name) {
        return new SymbolDeclaration(name, SymbolType.VAR);
    }

    public static SymbolDeclaration createSetDeclaration(String name) {
        return new SymbolDeclaration(name, SymbolType.SET);
    }

    public static SymbolDeclaration createSymbolDeclaration(String name, SymbolType type) {
        return new SymbolDeclaration(name, type);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SymbolDeclaration)) {
            return false;
        }
        SymbolDeclaration o = (SymbolDeclaration)obj;
        return this.name.equals(o.name);
    }

    public Object clone() {
        SymbolDeclaration sd = SymbolDeclaration.createSymbolDeclaration(this.name, this.type);
        HashMap<DeclarationAttributeEnum, Object> a = new HashMap<DeclarationAttributeEnum, Object>();
        for (Map.Entry<DeclarationAttributeEnum, Object> e : this.attributes.entrySet()) {
            if (e.getValue() instanceof Expression) {
                Expression ori = (Expression)e.getValue();
                Expression exp = (Expression)ori.clone();
                a.put(e.getKey(), exp);
                continue;
            }
            if (e.getValue() instanceof Boolean) {
                a.put(e.getKey(), e.getValue());
                continue;
            }
            throw new ModelException("Unsupported attribute for clone operation " + (Object)((Object)e.getKey()));
        }
        return sd;
    }

    public static enum SymbolType {
        PARAM,
        VAR,
        SET;

    }

    public static enum DeclarationAttributeEnum {
        INTEGER,
        VALUE,
        BINDED_VALUE,
        BINARY,
        LOWER_BOUND,
        UPPER_BOUND,
        SET_DIMEN,
        SET_WITHIN,
        SET_ASSIGN,
        SET_DEFAULT,
        SET_ORDERED,
        SET_CIRCULAR;

    }
}

