/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model.xml;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import net.vatov.ampl.model.ConstraintDeclaration;
import net.vatov.ampl.model.ObjectiveDeclaration;
import net.vatov.ampl.model.OptimModel;
import net.vatov.ampl.model.SymbolDeclaration;
import net.vatov.ampl.model.xml.ConstraintDeclarationConverter;
import net.vatov.ampl.model.xml.ExpressionConverter;
import net.vatov.ampl.model.xml.ObjectiveDeclarationConverter;
import net.vatov.ampl.model.xml.SymbolDeclarationConverter;
import net.vatov.ampl.model.xml.XmlModelException;
import org.apache.log4j.Logger;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class AmplXmlPersister {
    private static Logger logger = Logger.getLogger(AmplXmlPersister.class);
    private XStream xstream = new XStream();
    private NameCoder coder = new NoNameCoder();

    public AmplXmlPersister() {
        this.xstream.alias("model", OptimModel.class);
        this.xstream.alias("symbol", SymbolDeclaration.class);
        this.xstream.alias("objective", ObjectiveDeclaration.class);
        this.xstream.alias("constraint", ConstraintDeclaration.class);
        this.xstream.registerConverter((Converter)new SymbolDeclarationConverter());
        this.xstream.registerConverter((Converter)new ExpressionConverter());
        this.xstream.registerConverter((Converter)new ObjectiveDeclarationConverter());
        this.xstream.registerConverter((Converter)new ConstraintDeclarationConverter());
    }

    public OptimModel read(InputStream inputStream) {
        try {
            XmlPullParserFactory instance = XmlPullParserFactory.newInstance();
            return (OptimModel)this.xstream.unmarshal((HierarchicalStreamReader)new XppReader((Reader)new InputStreamReader(inputStream), instance.newPullParser(), this.coder));
        }
        catch (XmlPullParserException e) {
            throw new XmlModelException(e);
        }
    }

    public void write(OptimModel model, OutputStream outputStream) {
        Object writer = logger.isDebugEnabled() ? new PrettyPrintWriter((Writer)new OutputStreamWriter(outputStream), this.coder) : new CompactWriter((Writer)new OutputStreamWriter(outputStream), this.coder);
        this.xstream.marshal((Object)model, (HierarchicalStreamWriter)writer);
    }
}

