/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import net.vatov.ampl.model.Expression;
import net.vatov.ampl.model.ModelException;
import net.vatov.ampl.model.NodeValue;
import net.vatov.ampl.model.SymbolDeclaration;
import net.vatov.ampl.model.xml.Util;

public class ExpressionConverter
implements Converter {
    private static final String VALUE_TYPE_FIELD = "value-type";
    private static final String EXPR_NODE = "expr";
    private static final String OPERATION_FIELD = "op";
    private static final String BUILTIN_FUNC_FIELD = "func";

    public boolean canConvert(Class type) {
        return Expression.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Expression e = (Expression)source;
        writer.startNode(EXPR_NODE);
        writer.addAttribute(VALUE_TYPE_FIELD, e.getType().toString());
        switch (e.getType()) {
            case DOUBLE: {
                writer.setValue(e.getValue().toString());
                break;
            }
            case SYMREF: {
                writer.setValue(e.getSymRef().getName());
                break;
            }
            case TREE: {
                writer.addAttribute(OPERATION_FIELD, e.getTreeValue().getOperation().toString().toLowerCase());
                if (e.getTreeValue().getOperation().equals((Object)NodeValue.OperationType.BUILTIN_FUNCTION)) {
                    writer.addAttribute(BUILTIN_FUNC_FIELD, e.getTreeValue().getBuiltinFunction().toString().toLowerCase());
                }
                if (null == e.getTreeValue().getOperands()) break;
                for (Expression o : e.getTreeValue().getOperands()) {
                    context.convertAnother((Object)o);
                }
                break;
            }
            default: {
                throw new ModelException("Not implemented");
            }
        }
        writer.endNode();
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Expression e = new Expression();
        Expression.ExpressionType valueType = Expression.ExpressionType.valueOf(reader.getAttribute(VALUE_TYPE_FIELD));
        switch (valueType) {
            case DOUBLE: {
                e.setValue(Double.parseDouble(reader.getValue()));
                break;
            }
            case SYMREF: {
                SymbolDeclaration decl = Util.getSymbolDeclaration(reader.getValue(), context);
                e.setSymRef(decl);
                break;
            }
            case TREE: {
                NodeValue.OperationType op = NodeValue.OperationType.valueOf(reader.getAttribute(OPERATION_FIELD).toUpperCase());
                NodeValue.BuiltinFunction fType = null;
                if (NodeValue.OperationType.BUILTIN_FUNCTION.equals((Object)op)) {
                    fType = NodeValue.BuiltinFunction.valueOf(reader.getAttribute(BUILTIN_FUNC_FIELD).toUpperCase());
                }
                ArrayList<Expression> operands = null;
                while (reader.hasMoreChildren()) {
                    if (null == operands) {
                        operands = new ArrayList<Expression>(2);
                    }
                    reader.moveDown();
                    operands.add((Expression)context.convertAnother((Object)e, Expression.class));
                    reader.moveUp();
                }
                if (NodeValue.OperationType.BUILTIN_FUNCTION.equals((Object)op)) {
                    e.setTreeValue(fType, operands);
                    break;
                }
                e.setTreeValue(op, operands.toArray(new Expression[operands.size()]));
                break;
            }
            default: {
                throw new ModelException("Do not know how to handle " + e.getType().toString());
            }
        }
        return e;
    }
}

