/*
 * Decompiled with CFR 0.152.
 */
package net.vatov.ampl.model.xml;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.vatov.ampl.model.Expression;
import net.vatov.ampl.model.ModelException;
import net.vatov.ampl.model.SymbolDeclaration;
import net.vatov.ampl.model.xml.Util;

public class SymbolDeclarationConverter
implements Converter {
    private static final String NAME_FIELD = "name";
    private static final String TYPE_FIELD = "type";

    public boolean canConvert(Class type) {
        return SymbolDeclaration.class.equals((Object)type);
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        SymbolDeclaration sd = (SymbolDeclaration)source;
        writer.addAttribute(NAME_FIELD, sd.getName());
        writer.addAttribute(TYPE_FIELD, sd.getType().toString());
        Map<SymbolDeclaration.DeclarationAttributeEnum, Object> attributes = sd.getAttributes();
        if (null != attributes) {
            block4: for (SymbolDeclaration.DeclarationAttributeEnum key : SymbolDeclaration.DeclarationAttributeEnum.values()) {
                if (!attributes.containsKey((Object)key)) continue;
                Object value = attributes.get((Object)key);
                if (!this.isDeclarationAttribute(key.toString(), true)) continue;
                switch (key) {
                    case BINDED_VALUE: 
                    case BINARY: 
                    case INTEGER: {
                        writer.addAttribute(key.toString().toLowerCase(), value.toString());
                        continue block4;
                    }
                    case LOWER_BOUND: 
                    case UPPER_BOUND: 
                    case VALUE: {
                        writer.startNode(key.toString().toLowerCase());
                        Expression e = (Expression)value;
                        context.convertAnother((Object)e);
                        writer.endNode();
                        continue block4;
                    }
                    default: {
                        throw new ModelException("unknown attribute " + key.toString());
                    }
                }
            }
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        SymbolDeclaration.SymbolType type = SymbolDeclaration.SymbolType.valueOf(reader.getAttribute(TYPE_FIELD));
        SymbolDeclaration sd = SymbolDeclaration.createSymbolDeclaration(reader.getAttribute(NAME_FIELD), type);
        HashMap<SymbolDeclaration.DeclarationAttributeEnum, Object> attributes = new HashMap<SymbolDeclaration.DeclarationAttributeEnum, Object>();
        Iterator it = reader.getAttributeNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!this.isDeclarationAttribute(name, false)) continue;
            String value = reader.getAttribute(name);
            SymbolDeclaration.DeclarationAttributeEnum attKey = SymbolDeclaration.DeclarationAttributeEnum.valueOf(name.toUpperCase());
            switch (attKey) {
                case BINARY: 
                case INTEGER: {
                    attributes.put(attKey, null == value ? null : Boolean.valueOf(Boolean.parseBoolean(value)));
                    break;
                }
                case BINDED_VALUE: {
                    attributes.put(SymbolDeclaration.DeclarationAttributeEnum.BINDED_VALUE, null == value ? null : Double.valueOf(Double.parseDouble(value)));
                }
            }
        }
        while (reader.hasMoreChildren()) {
            Expression e;
            reader.moveDown();
            String nodeName = reader.getNodeName();
            reader.moveDown();
            if (SymbolDeclaration.DeclarationAttributeEnum.VALUE.toString().toLowerCase().equals(nodeName)) {
                e = (Expression)context.convertAnother((Object)sd, Expression.class);
                if (null != e) {
                    attributes.put(SymbolDeclaration.DeclarationAttributeEnum.VALUE, e);
                }
            } else if (SymbolDeclaration.DeclarationAttributeEnum.LOWER_BOUND.toString().toLowerCase().equals(nodeName)) {
                e = (Expression)context.convertAnother((Object)sd, Expression.class);
                if (null != e) {
                    attributes.put(SymbolDeclaration.DeclarationAttributeEnum.LOWER_BOUND, e);
                }
            } else if (SymbolDeclaration.DeclarationAttributeEnum.UPPER_BOUND.toString().toLowerCase().equals(nodeName) && null != (e = (Expression)context.convertAnother((Object)sd, Expression.class))) {
                attributes.put(SymbolDeclaration.DeclarationAttributeEnum.UPPER_BOUND, e);
            }
            reader.moveUp();
            reader.moveUp();
        }
        if (!attributes.isEmpty()) {
            sd.setAttributes(attributes);
        }
        Util.setSymbolDeclaration(sd.getName(), sd, context);
        return sd;
    }

    private boolean isDeclarationAttribute(String key, boolean marshal) {
        if (NAME_FIELD.equals(key) || TYPE_FIELD.equals(key)) {
            return false;
        }
        SymbolDeclaration.DeclarationAttributeEnum attKey = SymbolDeclaration.DeclarationAttributeEnum.valueOf(key.toUpperCase());
        switch (attKey) {
            case BINDED_VALUE: 
            case BINARY: 
            case INTEGER: {
                return true;
            }
            case LOWER_BOUND: 
            case UPPER_BOUND: 
            case VALUE: {
                return marshal;
            }
        }
        return false;
    }
}

