/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp.conf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;

public class FileProperties extends Properties {
	private final File propertiesFile;

	public FileProperties(File propertiesFile) throws FileNotFoundException, IOException {
		super();
		this.propertiesFile = propertiesFile;
		if (propertiesFile.exists()) {
			final FileReader reader = new FileReader(propertiesFile);
			super.load(reader);
			reader.close();
		}
	}

	/**
	 * Stores the properties to the file.
	 * 
	 * @throws IOException
	 *             If the file does not exists anymore or when no more space
	 *             left on device.
	 */
	public void store() throws IOException {
		final FileWriter writer = new FileWriter(propertiesFile);
		super.store(writer, "");
		writer.close();
	}
}
