/*
 * Decompiled with CFR 0.152.
 */
package net.vectorpublish.desktop.vp;

import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import net.vectorpublish.desktop.vp.api.conf.Config;
import net.vectorpublish.desktop.vp.conf.FileProperties;
import net.vectorpublish.desktop.vp.ui.Namespace;

@Named
public class ConfigImpl
implements Config {
    private static final String SEPARATOR = ".";
    private static final Set<Logger> avoidGarbagecollectConfiguredLevels = new LinkedHashSet<Logger>();
    private FileProperties propertiesFile;

    public Rectangle loadBounds(Namespace namespace, String key) {
        String name = namespace + SEPARATOR + key;
        try {
            int x = Integer.parseInt(this.propertiesFile.get(name + ".x") + "");
            int y = Integer.parseInt(this.propertiesFile.get(name + ".y") + "");
            int w = Integer.parseInt(this.propertiesFile.get(name + ".w") + "");
            int h = Integer.parseInt(this.propertiesFile.get(name + ".h") + "");
            return new Rectangle(x, y, w, h);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @PostConstruct
    private final void read() throws IOException {
        this.propertiesFile = new FileProperties(new File("config.properties"));
        for (Object key : this.propertiesFile.keySet()) {
            Class<?> target;
            Level level;
            Object value = this.propertiesFile.get(key);
            if (!key.toString().startsWith("log.")) continue;
            key = key.toString().substring(4);
            try {
                level = Level.parse("" + value);
            }
            catch (IllegalArgumentException e) {
                level = null;
            }
            try {
                target = Class.forName("" + key);
            }
            catch (ClassNotFoundException e) {
                target = null;
            }
            if (level == null && target != null) {
                System.err.println(value + " is not a valid JUL logging level for " + value);
                continue;
            }
            Logger logger = Logger.getLogger(key + "");
            if (level != null && target == null) {
                System.err.println(key + " class not found for logging on level " + level + "!");
                System.err.println("Try to activate logger for category " + key + " on level " + level + "!");
            } else if (level != null && target != null) {
                System.err.println("Activate JUL logging on level " + level + " for class " + target);
            }
            logger.setLevel(level);
            ConsoleHandler handler = new ConsoleHandler();
            handler.setLevel(level);
            logger.addHandler(handler);
            avoidGarbagecollectConfiguredLevels.add(logger);
        }
    }

    public String read(Namespace namespace, String key) {
        return this.propertiesFile.getProperty(namespace.getConfigNamespace() + SEPARATOR + key);
    }

    public void storeBounds(Namespace namespace, String key, Rectangle bounds) {
        String name = namespace + SEPARATOR + key;
        this.propertiesFile.setProperty(name + ".x", "" + bounds.x);
        this.propertiesFile.setProperty(name + ".y", "" + bounds.y);
        this.propertiesFile.setProperty(name + ".w", "" + bounds.width);
        this.propertiesFile.setProperty(name + ".h", "" + bounds.height);
    }

    @PreDestroy
    private final void write() throws IOException {
        this.propertiesFile.store();
    }

    public void write(Namespace namespace, String key, String value) {
        this.propertiesFile.setProperty(namespace.getConfigNamespace() + SEPARATOR + key, value);
    }
}

