/*
 * Copyright (c) 2016, Peter Rader. All rights reserved.
 *  ___ ___               __                 ______         __     __  __         __
 * |   |   |.-----..----.|  |_ .-----..----.|   __ \.--.--.|  |--.|  ||__|.-----.|  |--.
 * |   |   ||  -__||  __||   _||  _  ||   _||    __/|  |  ||  _  ||  ||  ||__ --||     |
 *  \_____/ |_____||____||____||_____||__|  |___|   |_____||_____||__||__||_____||__|__|
 *
 * http://www.gnu.org/licenses/gpl-3.0.html
 */
package net.vectorpublish.desktop.vp;

import java.util.Locale.LanguageRange;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;

import net.vectorpublish.desktop.vp.api.conf.Config;
import net.vectorpublish.desktop.vp.i8n.LanguageChangeListener;
import net.vectorpublish.desktop.vp.log.Log;
import net.vectorpublish.desktop.vp.ui.Namespace;

@Named
public class LanguageController {

	private static final Namespace NAMESPACE = Namespace.getNamespace("net.vectorpublish.i8n", "language");

	@Inject
	private final LanguageChangeListener[] listerner = null;

	@Inject
	private final Config config = null;

	@Inject
	private final Log log = null;

	/**
	 * The range for the fallback, if no other Range is supported or could not
	 * be parsed.
	 */
	public static final LanguageRange FALLBACK_RANGE = new LanguageRange("en-EN");

	@PostConstruct
	private void setup() {
		final String configuredLanguage = config.read(NAMESPACE, "language");
		LanguageRange language;
		if (configuredLanguage != null) {
			language = new LanguageRange(configuredLanguage);
		} else {
			String lang = System.getenv("LANG");
			if (lang == null) {
				language = FALLBACK_RANGE;
			} else {
				try {
					language = new LanguageRange(lang);
				} catch (final RuntimeException e) {
					log.system(e.getMessage());
					language = FALLBACK_RANGE;
				}
			}
		}
		for (final LanguageChangeListener languageChangeListener : listerner) {
			languageChangeListener.changedTo(language);
		}
	}
}
