/*
 * Decompiled with CFR 0.152.
 */
package net.vectorpublish.desktop.vp;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.imageio.ImageIO;
import javax.inject.Named;
import javax.swing.ImageIcon;
import net.vectorpublish.desktop.vp.LanguageController;
import net.vectorpublish.desktop.vp.api.ContextHolder;
import net.vectorpublish.desktop.vp.i8n.LanguageChangeListener;
import net.vectorpublish.desktop.vp.log.Log;
import net.vectorpublish.desktop.vp.ui.ImageKey;
import net.vectorpublish.desktop.vp.ui.Namespace;
import net.vectorpublish.desktop.vp.ui.i8n.I8nImageFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class DefaultI8nImageFactory
implements I8nImageFactory,
LanguageChangeListener {
    public static ImageIcon HOST_NOT_FOUND_IMG;
    public static final String NET_VECTORPUBLISH_I8N_PROTOCOL = "net.vectorpublish.i8n.protocol";
    public static final String NET_VECTORPUBLISH_I8N_SERVER = "net.vectorpublish.i8n.server";
    private boolean hasTranslationServer = true;
    protected final HashMap<String, ImageIcon> icons = new HashMap();
    @Autowired
    protected final Log log = null;
    private Locale.LanguageRange lang = LanguageController.FALLBACK_RANGE;
    private String version;

    public void changedTo(Locale.LanguageRange lr) {
        this.lang = lr;
    }

    public ImageIcon get(Namespace namespace, ImageKey key, boolean small) {
        String name = namespace + "/" + key.getCanonical() + (small ? "/small" : "/large");
        if (this.icons.containsKey(name)) {
            this.log.found((Object)("Image for key " + name + " in cache!"));
            return this.icons.get(name);
        }
        if (!this.hasTranslationServer) {
            this.log.missing((Object)"Translation server", "Exit application");
            if (ContextHolder.context == null) {
                System.exit(1);
            } else {
                ContextHolder.context.close();
            }
        }
        URL url = null;
        try {
            String transApp = this.getTranslationServer();
            String location = transApp + "rest/images/" + this.lang.getRange() + "/" + name;
            this.log.calculated("Image URL:", (Object)location);
            url = new URL(location);
            URLConnection openConnection = url.openConnection();
            int timeoutMS = 200;
            this.log.searching((Object)"Configuration for request timeout");
            String configuredTimeout = System.getProperty("net.vectorpublish.i8n.timeout_in_ms");
            if (configuredTimeout != null) {
                this.log.found((Object)("Timeout of " + configuredTimeout));
                timeoutMS = Integer.parseInt(configuredTimeout);
                if (timeoutMS < 1) {
                    throw new NumberFormatException("Timeout must be at least 1!");
                }
            } else {
                this.log.missing((Object)"Timeout", "Using default: " + timeoutMS);
            }
            openConnection.setConnectTimeout(timeoutMS);
            openConnection.setReadTimeout(timeoutMS);
            InputStream inputStream = openConnection.getInputStream();
            this.log.system((Object)"Reading image.");
            BufferedImage read = ImageIO.read(new URL(location));
            inputStream.close();
            if (read != null) {
                ImageIcon imageIcon = new ImageIcon(read);
                this.log.cache("Image for namespace '" + name + "'.");
                this.icons.put(name, imageIcon);
                return imageIcon;
            }
            this.log.missing((Object)location, "Not recieved!");
        }
        catch (UnknownHostException e) {
            this.log.missing((Object)e.getMessage(), "Host not found, using placeholder image.");
            return HOST_NOT_FOUND_IMG;
        }
        catch (SocketTimeoutException e) {
            this.log.timeout(url, "Too slow to read Image");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            this.log.missing(url, "Image not found, mark as no internet!");
            this.hasTranslationServer = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            ContextHolder.context.close();
        }
        return null;
    }

    public String getTranslationServer() throws IOException {
        String protocol = this.loadProtocol();
        String server = this.loadServer();
        String transApp = protocol + "://" + server + "/I8n-Server-" + this.version + "/";
        return transApp;
    }

    @PostConstruct
    public void load() throws IOException, ClassNotFoundException {
        this.log.searching((Object)"Package of vectorpublish to read version-info.");
        Package pack = DefaultI8nImageFactory.class.getPackage();
        this.log.found((Object)("Package: " + pack));
        this.log.searching((Object)"Version");
        String ver = pack.getImplementationVersion();
        if (ver == null) {
            this.log.missing((Object)"Version", "In package");
            this.log.searching((Object)"Version in manifest");
            Enumeration<URL> resources = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL manifestURL = resources.nextElement();
                this.log.checkThat((Object)manifestURL, "contains manifest.");
                InputStream openStream = manifestURL.openStream();
                Manifest mf = new Manifest(openStream);
                openStream.close();
                Attributes mainAttributes = mf.getMainAttributes();
                this.log.found((Object)("Manifest-Main-Attributes:" + mainAttributes.size()));
                for (Map.Entry<Object, Object> s : mainAttributes.entrySet()) {
                    this.log.found((Object)("Attribute " + s.getKey() + " = " + s.getValue()));
                }
                String vendor = mainAttributes.getValue("Implementation-Vendor-Id");
                if (vendor == null || !vendor.equals("net.vectorpublish")) continue;
                ver = mainAttributes.getValue("Implementation-Version");
                this.log.found((Object)("Version " + ver + " in manifest (" + manifestURL + ")."));
                break;
            }
            if (ver == null) {
                this.log.missing((Object)"Version", "In manifests.");
            }
        } else {
            this.log.found((Object)("Version " + ver + " from package."));
        }
        this.version = ver;
        File f = new File("icons" + this.version + ".cache");
        if (f.exists()) {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(f));
            Map hm = (Map)ois.readObject();
            this.icons.clear();
            this.icons.putAll(hm);
            ois.close();
        }
    }

    private String loadProtocol() {
        String protocol = "http";
        this.log.searching((Object)("Looking for different protocol than " + protocol));
        String overrideProtocol = System.getProperty(NET_VECTORPUBLISH_I8N_PROTOCOL);
        if (overrideProtocol != null) {
            this.log.found((Object)"Override protocol (net.vectorpublish.i8n.protocol)");
            this.log.override("Protocol", (Object)protocol, (Object)protocol);
            protocol = overrideProtocol;
        } else {
            this.log.missing((Object)"Override protocol (net.vectorpublish.i8n.protocol)", "Keep " + protocol);
        }
        return protocol;
    }

    private String loadServer() {
        String server = "www.vectorpublish.net";
        this.log.searching((Object)("Looking for different server than " + server));
        String overrideServer = System.getProperty(NET_VECTORPUBLISH_I8N_SERVER);
        if (overrideServer != null) {
            this.log.found((Object)"Override server (net.vectorpublish.i8n.server)");
            this.log.override("Server", (Object)server, (Object)server);
            server = overrideServer;
        } else {
            this.log.missing((Object)"Override server (net.vectorpublish.i8n.server)", "Keep " + server);
        }
        return server;
    }

    @PreDestroy
    public void persist() throws IOException {
        File f = new File("icons" + this.version + ".cache");
        ObjectOutputStream os = new ObjectOutputStream(new FileOutputStream(f));
        os.writeObject(this.icons);
        os.close();
    }

    static {
        BufferedImage image = new BufferedImage(32, 32, 2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(new Color(0, 0, 0, 0));
        graphics.fillRect(0, 0, 32, 32);
        graphics.setFont(new Font("Helvetica", 0, 10));
        graphics.setColor(Color.BLACK);
        graphics.drawString("Host", 0, 10);
        graphics.drawString("not", 0, 20);
        graphics.drawString("found!", 0, 30);
        HOST_NOT_FOUND_IMG = new ImageIcon(image);
    }
}

