/*
 * Decompiled with CFR 0.152.
 */
package net.vectorpublish.desktop.vp;

import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import net.vectorpublish.desktop.vp.api.conf.Config;
import net.vectorpublish.desktop.vp.i8n.LanguageChangeListener;
import net.vectorpublish.desktop.vp.log.Log;
import net.vectorpublish.desktop.vp.ui.Namespace;

@Named
public class LanguageController {
    private static final Namespace NAMESPACE = Namespace.getNamespace((String)"net.vectorpublish.i8n", (String)"language");
    @Inject
    private final LanguageChangeListener[] listerner = null;
    @Inject
    private final Config config = null;
    @Inject
    private final Log log = null;
    public static final Locale.LanguageRange FALLBACK_RANGE = new Locale.LanguageRange("en-EN");

    @PostConstruct
    private void setup() {
        Locale.LanguageRange language;
        String configuredLanguage = this.config.read(NAMESPACE, "language");
        if (configuredLanguage != null) {
            language = new Locale.LanguageRange(configuredLanguage);
        } else {
            String lang = System.getenv("LANG");
            if (lang == null) {
                language = FALLBACK_RANGE;
            } else {
                try {
                    language = new Locale.LanguageRange(lang);
                }
                catch (RuntimeException e) {
                    this.log.system((Object)e.getMessage());
                    language = FALLBACK_RANGE;
                }
            }
        }
        for (LanguageChangeListener languageChangeListener : this.listerner) {
            languageChangeListener.changedTo(language);
        }
    }
}

