/*
 * Decompiled with CFR 0.152.
 */
package net.vectorpublish.desktop.vp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import net.vectorpublish.desktop.vp.DefaultI8nImageFactory;
import net.vectorpublish.desktop.vp.LanguageController;
import net.vectorpublish.desktop.vp.api.conf.Config;
import net.vectorpublish.desktop.vp.api.ui.Dialog;
import net.vectorpublish.desktop.vp.i8n.I8n;
import net.vectorpublish.desktop.vp.i8n.I8nText;
import net.vectorpublish.desktop.vp.i8n.LanguageChangeListener;
import net.vectorpublish.desktop.vp.log.Log;
import net.vectorpublish.desktop.vp.ui.Namespace;
import org.apache.commons.io.IOUtils;

@Named
public class Translation
extends Properties
implements I8n {
    public static final Namespace DIALOG_NAMESPACE = Namespace.getNamespace((String)"net.vectorpublish", (String)"system.i8n");
    private static final File localFile = new File("translation.properties");
    @Inject
    private final Log log = null;
    @Inject
    private final Dialog dialog = null;
    @Inject
    private final Config config = null;
    @Inject
    private final LanguageChangeListener[] listeners = null;
    private Locale.LanguageRange currentLanguage = LanguageController.FALLBACK_RANGE;
    @Inject
    private final DefaultI8nImageFactory translationServerFactory = null;

    public Translation() {
        if (localFile.exists()) {
            try (FileReader fr = new FileReader(localFile);){
                this.load(fr);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String getTranslation(I8nText key) {
        Namespace namespace;
        String finalKey;
        String translation;
        if (this.isEmpty()) {
            String read = this.config.read(DIALOG_NAMESPACE, "language");
            if (read == null) {
                read = "en-en";
            }
            this.setLanguage(new Locale.LanguageRange(read));
        }
        if ((translation = this.getProperty(finalKey = (namespace = key.getNamespace()) + "/" + key.getKey())) == null) {
            try {
                URL url = new URL(this.translationServerFactory.getTranslationServer() + "rest/properties/" + this.currentLanguage.getRange() + "/" + namespace + "/" + key.getKey());
                translation = IOUtils.toString((URL)url);
                this.put(finalKey, translation);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (translation == null) {
            block39: {
                this.log.missing((Object)finalKey, "in the translation, got to ask the user.");
                Future ask = this.dialog.ask(DIALOG_NAMESPACE, "What do you think is the Translation of '" + key.getKey() + "'?", (Object[])new String[]{key.getKey()});
                Future store = this.dialog.ask(DIALOG_NAMESPACE, "Store?", (Object[])new Boolean[]{true});
                try {
                    Throwable throwable;
                    translation = (String)ask.get();
                    this.put(finalKey, translation);
                    if (!((Boolean)store.get()).booleanValue()) break block39;
                    Properties p = new Properties();
                    if (localFile.exists()) {
                        try {
                            throwable = null;
                            try (FileReader fr = new FileReader(localFile);){
                                p.load(fr);
                                p.setProperty(finalKey, translation);
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    p.setProperty(finalKey, translation);
                    try {
                        throwable = null;
                        try (FileWriter fw = new FileWriter(localFile);){
                            p.store(fw, "");
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (translation == null) {
                return key.getKey();
            }
        }
        return translation;
    }

    public void setLanguage(Locale.LanguageRange newLanguage) {
        boolean changed;
        boolean bl = changed = !newLanguage.getRange().equals(this.currentLanguage.getRange());
        if (changed) {
            this.clear();
            this.currentLanguage = newLanguage;
            for (LanguageChangeListener listener : this.listeners) {
                listener.changedTo(newLanguage);
            }
        }
    }

    @PreDestroy
    public void tearDown() throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(localFile);
        this.store(out, "");
        out.close();
    }
}

