package net.vectorpublish.desktop.vp;

import java.awt.event.ActionEvent;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;

import net.vectorpublish.desktop.vp.api.history.Redo;
import net.vectorpublish.desktop.vp.api.ui.Dialog;
import net.vectorpublish.desktop.vp.api.ui.ToolBar;
import net.vectorpublish.desktop.vp.api.ui.VPAbstractAction;
import net.vectorpublish.desktop.vp.api.ui.Warn;
import net.vectorpublish.desktop.vp.img.ImageTexts;
import net.vectorpublish.desktop.vp.split.SplitNode;
import net.vectorpublish.desktop.vp.ui.ImageKey;

@Named
public class SetImageButton extends VPAbstractAction {

	public SetImageButton() {
		super(ImageTexts.ADD_IMAGE, ImageTexts.SET_IMAGE_TOOLTIP, true);
	}

	@Inject
	private final ToolBar tb = null;

	@Inject
	private final Dialog dlg = null;

	private SplitNode splitter;

	@Inject
	private final History hist = null;

	@Inject
	private final Redo redo = null;

	@Inject
	private final Warn warn = null;

	@Override
	public void actionPerformed(ActionEvent e) {

	}

	@PostConstruct
	public void setup() {
		setIcons(ImageTexts.NS, ImageKey.get("add_image"));
		tb.add(this);
	}
}
