/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.vidageek.crawler.PageVisitor;
import net.vidageek.crawler.Url;
import net.vidageek.crawler.component.Downloader;
import net.vidageek.crawler.component.ExecutorCounter;
import net.vidageek.crawler.component.LinkNormalizer;
import net.vidageek.crawler.component.PageCrawlerExecutor;
import net.vidageek.crawler.config.CrawlerConfiguration;
import net.vidageek.crawler.exception.CrawlerException;
import net.vidageek.crawler.queue.DelayedBlockingQueue;
import net.vidageek.crawler.visitor.DoesNotFollowVisitedUrlVisitor;
import org.apache.log4j.Logger;

public class PageCrawler {
    private final Logger log = Logger.getLogger(PageCrawler.class);
    private final CrawlerConfiguration config;

    public PageCrawler(CrawlerConfiguration config) {
        this.config = config;
    }

    public PageCrawler(String beginUrl) {
        this(CrawlerConfiguration.forStartPoint(beginUrl).build());
    }

    public PageCrawler(String beginUrl, Downloader downloader, LinkNormalizer normalizer) {
        this.config = CrawlerConfiguration.forStartPoint(beginUrl).withDownloader(downloader).withLinkNormalizer(normalizer).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void crawl(PageVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("visitor cannot be null");
        }
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.config.minPoolSize(), this.config.maxPoolSize(), this.config.keepAliveMilliseconds(), TimeUnit.MILLISECONDS, new DelayedBlockingQueue(this.config.requestDelayMilliseconds()));
        ExecutorCounter counter = new ExecutorCounter();
        try {
            executor.execute(new PageCrawlerExecutor(new Url(this.config.beginUrl(), 0), executor, counter, this.config.downloader(), this.config.normalizer(), new DoesNotFollowVisitedUrlVisitor(this.config.beginUrl(), visitor)));
            while (counter.value() != 0) {
                this.log.debug((Object)("executors that finished: " + executor.getCompletedTaskCount()));
                this.log.debug((Object)("Number of Executors alive: " + counter.value()));
                this.sleep();
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private void sleep() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new CrawlerException("main thread died. ", e);
        }
    }
}

