/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.component;

import java.util.concurrent.ThreadPoolExecutor;
import net.vidageek.crawler.Page;
import net.vidageek.crawler.PageVisitor;
import net.vidageek.crawler.Status;
import net.vidageek.crawler.Url;
import net.vidageek.crawler.component.Downloader;
import net.vidageek.crawler.component.ExecutorCounter;
import net.vidageek.crawler.component.LinkNormalizer;
import org.apache.log4j.Logger;

public final class PageCrawlerExecutor
implements Runnable {
    private final Downloader downloader;
    private final LinkNormalizer normalizer;
    private final PageVisitor visitor;
    private final ExecutorCounter counter;
    private final Logger log = Logger.getLogger(PageCrawlerExecutor.class);
    private final Url urlToCrawl;
    private final ThreadPoolExecutor executor;

    public PageCrawlerExecutor(Url urlToCrawl, ThreadPoolExecutor executor, ExecutorCounter counter, Downloader downloader, LinkNormalizer normalizer, PageVisitor visitor) {
        this.urlToCrawl = urlToCrawl;
        this.executor = executor;
        this.counter = counter;
        this.downloader = downloader;
        this.normalizer = normalizer;
        this.visitor = visitor;
        counter.increase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.log.info((Object)("crawling url: " + this.urlToCrawl.link()));
            Page page = this.downloader.get(this.urlToCrawl.link());
            if (page.getStatusCode() != Status.OK) {
                this.visitor.onError(this.urlToCrawl, page.getStatusCode());
            } else {
                this.visitor.visit(page);
            }
            for (String l : page.getLinks()) {
                String link = this.normalizer.normalize(l);
                Url url = new Url(link, this.urlToCrawl.depth() + 1);
                if (!this.visitor.followUrl(url)) continue;
                this.executor.execute(new PageCrawlerExecutor(url, this.executor, this.counter, this.downloader, this.normalizer, this.visitor));
            }
        }
        finally {
            this.counter.decrease();
        }
    }
}

