/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.component;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.vidageek.crawler.Page;
import net.vidageek.crawler.Status;
import net.vidageek.crawler.component.Downloader;
import net.vidageek.crawler.config.http.Cookie;
import net.vidageek.crawler.exception.CrawlerException;
import net.vidageek.crawler.page.ErrorPage;
import net.vidageek.crawler.page.OkPage;
import net.vidageek.crawler.page.RejectedMimeTypePage;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.log4j.Logger;

public class WebDownloader
implements Downloader {
    private final ConcurrentLinkedQueue<String> mimeTypesToInclude;
    private final Logger log = Logger.getLogger(WebDownloader.class);
    private final ConcurrentLinkedQueue<Cookie> cookies;

    public WebDownloader(List<String> mimeTypesToInclude) {
        this(mimeTypesToInclude, new ArrayList<Cookie>());
    }

    public WebDownloader(List<String> mimeTypesToInclude, List<Cookie> cookies) {
        this.cookies = new ConcurrentLinkedQueue<Cookie>(cookies);
        this.mimeTypesToInclude = new ConcurrentLinkedQueue<String>(mimeTypesToInclude);
    }

    public WebDownloader() {
        this(Arrays.asList("text/html"));
    }

    @Override
    public Page get(String url) {
        DefaultHttpClient client = new DefaultHttpClient();
        for (Cookie cookie : this.cookies) {
            String name = cookie.name();
            String value = cookie.value();
            this.log.debug((Object)("Creating cookie [" + name + " = " + value + "] " + cookie.domain()));
            BasicClientCookie clientCookie = new BasicClientCookie(name, value);
            clientCookie.setPath(cookie.path());
            clientCookie.setDomain(cookie.domain());
            client.getCookieStore().addCookie((org.apache.http.cookie.Cookie)clientCookie);
        }
        client.getParams().setIntParameter("http.socket.timeout", 15000);
        return this.get((HttpClient)client, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Page get(HttpClient client, String url) {
        try {
            String encodedUrl = this.encode(url);
            this.log.debug((Object)("Requesting url: [" + encodedUrl + "]"));
            HttpGet method = new HttpGet(encodedUrl);
            try {
                HttpResponse response = client.execute((HttpUriRequest)method);
                Status status = Status.fromHttpCode(response.getStatusLine().getStatusCode());
                if (!this.acceptsMimeType(response.getLastHeader("Content-Type"))) {
                    RejectedMimeTypePage rejectedMimeTypePage = new RejectedMimeTypePage(url, status, response.getLastHeader("Content-Type").getValue());
                    return rejectedMimeTypePage;
                }
                if (Status.OK.equals((Object)status)) {
                    CharsetDetector detector = new CharsetDetector();
                    detector.setText(this.read(response.getEntity().getContent()));
                    CharsetMatch match = detector.detect();
                    this.log.debug((Object)("Detected charset: " + match.getName()));
                    String content = match.getString();
                    CharBuffer buffer = CharBuffer.wrap(content.toCharArray());
                    Charset utf8Charset = Charset.forName("UTF-8");
                    String utf8Content = new String(utf8Charset.encode(buffer).array(), "UTF-8");
                    OkPage okPage = new OkPage(url, utf8Content);
                    return okPage;
                }
                ErrorPage errorPage = new ErrorPage(url, status);
                return errorPage;
            }
            finally {
                method.abort();
            }
        }
        catch (IOException e) {
            throw new CrawlerException("Could not retrieve data from " + url, e);
        }
    }

    private boolean acceptsMimeType(Header header) {
        String value = header.getValue();
        if (value == null) {
            return false;
        }
        for (String mimeType : this.mimeTypesToInclude) {
            if (!value.contains(mimeType)) continue;
            return true;
        }
        return false;
    }

    private byte[] read(InputStream inputStream) {
        byte[] bytes = new byte[1000];
        int i = 0;
        try {
            int b;
            while ((b = inputStream.read()) != -1) {
                bytes[i++] = (byte)b;
                if (bytes.length != i) continue;
                byte[] newBytes = new byte[bytes.length * 3 / 2 + 1];
                for (int j = 0; j < bytes.length; ++j) {
                    newBytes[j] = bytes[j];
                }
                bytes = newBytes;
            }
        }
        catch (IOException e) {
            new CrawlerException("There was a problem reading stream.", e);
        }
        byte[] copy = Arrays.copyOf(bytes, i);
        return copy;
    }

    private String encode(String url) {
        String res = "";
        for (char c : url.toCharArray()) {
            if (!":/.?&#=".contains("" + c)) {
                try {
                    res = res + URLEncoder.encode("" + c, "UTF-8");
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new CrawlerException("There is something really wrong with your JVM. It could not find UTF-8 encoding.", e);
                }
            }
            res = res + c;
        }
        return res;
    }
}

