/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.config;

import java.util.regex.Pattern;
import net.vidageek.crawler.component.DefaultLinkNormalizer;
import net.vidageek.crawler.component.Downloader;
import net.vidageek.crawler.component.LinkNormalizer;
import net.vidageek.crawler.component.WebDownloader;
import net.vidageek.crawler.config.CrawlerConfigurationBuilder;

public final class CrawlerConfiguration {
    private final String beginUrl;
    private Downloader downloader;
    private LinkNormalizer normalizer;
    private int minPoolSize;
    private int maxPoolSize;
    private long keepAliveMilliseconds;
    private int requestDelayMilliseconds;

    public CrawlerConfiguration(String beginUrl) {
        if (beginUrl == null || beginUrl.trim().length() == 0) {
            throw new IllegalArgumentException("beginUrl cannot be null or empty");
        }
        if (!Pattern.compile("(?s)^http[s]?://.*$").matcher(beginUrl).matches()) {
            throw new IllegalArgumentException("beginUrl must start with http:// or https://");
        }
        this.beginUrl = beginUrl;
        this.downloader = new WebDownloader();
        this.normalizer = new DefaultLinkNormalizer(beginUrl);
        this.minPoolSize = 30;
        this.maxPoolSize = 30;
        this.keepAliveMilliseconds = 30000L;
        this.requestDelayMilliseconds = 1000;
    }

    public String beginUrl() {
        return this.beginUrl;
    }

    public Downloader downloader() {
        return this.downloader;
    }

    public LinkNormalizer normalizer() {
        return this.normalizer;
    }

    public int minPoolSize() {
        return this.minPoolSize;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public long keepAliveMilliseconds() {
        return this.keepAliveMilliseconds;
    }

    public int requestDelayMilliseconds() {
        return this.requestDelayMilliseconds;
    }

    public static CrawlerConfigurationBuilder forStartPoint(String beginUrl) {
        return new CrawlerConfigurationBuilder(beginUrl);
    }

    public void downloader(Downloader downloader) {
        this.downloader = downloader;
    }

    public void linkNormalizer(LinkNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public void minPoolSize(int minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public void maxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void keepAliveMilliseconds(int keepAliveMilliseconds) {
        this.keepAliveMilliseconds = keepAliveMilliseconds;
    }

    public void requestDelayMilliseconds(int requestDelayMilliseconds) {
        this.requestDelayMilliseconds = requestDelayMilliseconds;
    }
}

