/*
 * Decompiled with CFR 0.152.
 */
package net.vidageek.crawler.config;

import net.vidageek.crawler.component.Downloader;
import net.vidageek.crawler.component.LinkNormalizer;
import net.vidageek.crawler.config.CrawlerConfiguration;

public final class CrawlerConfigurationBuilder {
    private final CrawlerConfiguration configuration;

    public CrawlerConfigurationBuilder(String beginUrl) {
        this.configuration = new CrawlerConfiguration(beginUrl);
    }

    public CrawlerConfigurationBuilder withDownloader(Downloader downloader) {
        if (downloader == null) {
            throw new IllegalArgumentException("downloader cannot be null");
        }
        this.configuration.downloader(downloader);
        return this;
    }

    public CrawlerConfigurationBuilder withLinkNormalizer(LinkNormalizer normalizer) {
        if (normalizer == null) {
            throw new IllegalArgumentException("link normalizer cannot be null");
        }
        this.configuration.linkNormalizer(normalizer);
        return this;
    }

    public CrawlerConfigurationBuilder withKeepAlive(int keepAliveMilliseconds) {
        this.configuration.keepAliveMilliseconds(keepAliveMilliseconds);
        return this;
    }

    public CrawlerConfigurationBuilder withRequestDelay(int requestDelayMilliseconds) {
        this.configuration.requestDelayMilliseconds(requestDelayMilliseconds);
        return this;
    }

    public CrawlerConfiguration build() {
        return this.configuration;
    }

    public CrawlerConfigurationBuilder withMaxParallelRequests(int numberOfRequests) {
        this.configuration.maxPoolSize(numberOfRequests);
        this.configuration.minPoolSize(numberOfRequests);
        return this;
    }
}

